/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.handlers;

import com.google.common.cache.LoadingCache;
import org.easymock.EasyMock;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payloads;
import org.jclouds.openstack.keystone.v2_0.handlers.RetryOnRenew;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RetryOnRenewTest")
public class RetryOnRenewTest {
    @Test
    public void test401ShouldRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request);
        cache.invalidateAll();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)Payloads.newStringPayload((String)"")).anyTimes();
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)401).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{command});
        EasyMock.replay((Object[])new Object[]{response});
        EasyMock.replay((Object[])new Object[]{cache});
        RetryOnRenew retry = new RetryOnRenew(cache);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{command});
        EasyMock.verify((Object[])new Object[]{response});
        EasyMock.verify((Object[])new Object[]{cache});
    }

    @Test
    public void test401ShouldRetry4Times() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        LoadingCache cache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).anyTimes();
        EasyMock.expect((Object)request.getHeaders()).andStubReturn(null);
        cache.invalidateAll();
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)response.getPayload()).andReturn((Object)Payloads.newStringPayload((String)"")).anyTimes();
        EasyMock.expect((Object)response.getStatusCode()).andReturn((Object)401).anyTimes();
        EasyMock.replay((Object[])new Object[]{command, request, response, cache});
        RetryOnRenew retry = new RetryOnRenew(cache);
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response), (String)"Expected retry to succeed");
        }
        Assert.assertFalse((boolean)retry.shouldRetryRequest(command, response), (String)"Expected retry to fail on attempt 5");
        EasyMock.verify((Object[])new Object[]{command, response, cache});
    }
}

