/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.domain.MediaType;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseDevstackApiMetadataTest")
public class ParseDevstackApiMetadataTest
extends BaseItemParserTest<ApiMetadata> {
    public String resource() {
        return "/devstackVersion.json";
    }

    @SelectJson(value={"version"})
    @Consumes(value={"application/json"})
    public ApiMetadata expected() {
        return ((ApiMetadata.Builder)((ApiMetadata.Builder)ApiMetadata.builder().id("v2.0")).links((Set)ImmutableSet.of((Object)Link.builder().relation(Link.Relation.SELF).href(URI.create("http://172.16.89.167:5000/v2.0/")).build(), (Object)Link.builder().relation(Link.Relation.DESCRIBEDBY).type("text/html").href(URI.create("http://docs.openstack.org/api/openstack-identity-service/2.0/content/")).build(), (Object)Link.builder().relation(Link.Relation.DESCRIBEDBY).type("application/pdf").href(URI.create("http://docs.openstack.org/api/openstack-identity-service/2.0/identity-dev-guide-2.0.pdf")).build()))).status("beta").updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-11-19T00:00:00+00:00")).mediaTypes((Set)ImmutableSet.of((Object)MediaType.builder().base("application/json").type("application/vnd.openstack.identity-v2.0+json").build(), (Object)MediaType.builder().base("application/xml").type("application/vnd.openstack.identity-v2.0+xml").build())).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new GsonModule(), new KeystoneParserModule()});
    }
}

