/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.predicates;

import java.net.URI;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.predicates.LinkPredicates;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="LinkPredicatesTest")
public class LinkPredicatesTest {
    Link ref = Link.builder().type("application/pdf").relation(Link.Relation.DESCRIBEDBY).href(URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).build();

    @Test
    public void testRelationEqualsWhenEqual() {
        assert (LinkPredicates.relationEquals((Link.Relation)Link.Relation.DESCRIBEDBY).apply((Object)this.ref));
    }

    @Test
    public void testRelationEqualsWhenNotEqual() {
        assert (!LinkPredicates.relationEquals((Link.Relation)Link.Relation.UNRECOGNIZED).apply((Object)this.ref));
    }

    @Test
    public void testTypeEqualsWhenEqual() {
        assert (LinkPredicates.typeEquals((String)"application/pdf").apply((Object)this.ref));
    }

    @Test
    public void testTypeEqualsWhenNotEqual() {
        assert (!LinkPredicates.typeEquals((String)"foo").apply((Object)this.ref));
    }

    @Test
    public void testHrefEqualsWhenEqual() {
        assert (LinkPredicates.hrefEquals((URI)URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).apply((Object)this.ref));
    }

    @Test
    public void testHrefEqualsWhenNotEqual() {
        assert (!LinkPredicates.hrefEquals((URI)URI.create("foo")).apply((Object)this.ref));
    }
}

