/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;

public class CredentialTypes {
    public static final String API_ACCESS_KEY_CREDENTIALS = "apiAccessKeyCredentials";
    public static final String PASSWORD_CREDENTIALS = "passwordCredentials";

    public static <T> String credentialTypeOf(T input) {
        Class<?> authenticationType = input.getClass();
        Preconditions.checkArgument((boolean)authenticationType.isAnnotationPresent(CredentialType.class), (String)"programming error: %s should have annotation %s", (Object[])new Object[]{authenticationType, CredentialType.class.getName()});
        return authenticationType.getAnnotation(CredentialType.class).value();
    }

    public static <T> Map<String, T> indexByCredentialType(Iterable<T> iterable) {
        return Maps.uniqueIndex(iterable, (Function)new Function<T, String>(){

            public String apply(T input) {
                return CredentialTypes.credentialTypeOf(input);
            }
        });
    }
}

