/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaComputeServiceExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaComputeServiceExpectTest")
public class NovaComputeServiceExpectTest
extends BaseNovaComputeServiceExpectTest {
    Map<HttpRequest, HttpResponse> defaultTemplateOpenStack;
    HttpRequest list;
    HttpResponse notFound;
    HttpRequest createWithPrefixOnGroup;
    HttpResponse securityGroupCreated;
    HttpRequest createRuleForDefaultPort22;
    HttpResponse securityGroupRuleCreated;
    HttpRequest getSecurityGroup;
    HttpResponse securityGroupWithPort22;
    HttpRequest create;
    HttpResponse keyPairWithPrivateKey;
    HttpRequest serverDetail;
    HttpResponse serverDetailResponse;

    public NovaComputeServiceExpectTest() {
        this.defaultTemplateOpenStack = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200").payload(this.payloadFromResourceWithContentType("/keystoneAuthResponse_openstack.json", "application/json"))).build()).put((Object)this.extensionsOfNovaRequest.toBuilder().endpoint("https://nova-api.openstack.org:9774/v1.1/3456/extensions").build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/extension_list_openstack.json"))).build()).put((Object)this.listDetail.toBuilder().endpoint("https://nova-api.openstack.org:9774/v1.1/3456/images/detail").build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/image_list_detail_openstack.json"))).build()).put((Object)this.listServers.toBuilder().endpoint("https://nova-api.openstack.org:9774/v1.1/3456/servers/detail").build(), (Object)this.listServersResponse).put((Object)this.listFlavorsDetail.toBuilder().endpoint("https://nova-api.openstack.org:9774/v1.1/3456/flavors/detail").build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/flavor_list_detail_openstack.json"))).build()).build();
        this.list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/os-security-groups").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.notFound = HttpResponse.builder().statusCode(404).build();
        this.createWithPrefixOnGroup = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/os-security-groups").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"security_group\":{\"name\":\"jclouds-test\",\"description\":\"jclouds-test\"}}", (String)"application/json"))).build();
        this.securityGroupCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_created.json"))).build();
        this.createRuleForDefaultPort22 = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/os-security-group-rules").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"security_group_rule\":{\"parent_group_id\":\"160\",\"cidr\":\"0.0.0.0/0\",\"ip_protocol\":\"tcp\",\"from_port\":\"22\",\"to_port\":\"22\"}}", (String)"application/json"))).build();
        this.securityGroupRuleCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygrouprule_created.json"))).build();
        this.getSecurityGroup = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/os-security-groups/160").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.securityGroupWithPort22 = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_details_port22.json"))).build();
        this.create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/os-keypairs").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"keypair\":{\"name\":\"jclouds-test-0\"}}", (String)"application/json"))).build();
        this.keyPairWithPrivateKey = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/keypair_created_computeservice.json"))).build();
        this.serverDetail = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/servers/71752").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.serverDetailResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/server_details.json"))).build();
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.zones", "az-1.region-a.geo-1,RegionOne");
        return overrides;
    }

    public void testListLocationsWhenResponseIs2xx() throws Exception {
        ImmutableMap requestResponseMap = ImmutableMap.builder().put((Object)this.keystoneAuthWithUsernameAndPasswordAndTenantName, (Object)this.responseWithKeystoneAccess).put((Object)this.extensionsOfNovaRequest, (Object)this.extensionsOfNovaResponse).put((Object)this.listDetail, (Object)this.listDetailResponse).put((Object)this.listServers, (Object)this.listServersResponse).put((Object)this.listFlavorsDetail, (Object)this.listFlavorsDetailResponse).build();
        ComputeService apiWhenServersExist = (ComputeService)this.requestsSendResponses((Map)requestResponseMap);
        Set locations = apiWhenServersExist.listAssignableLocations();
        Assert.assertNotNull((Object)locations);
        Assert.assertEquals((int)locations.size(), (int)1);
        Assert.assertEquals((String)((Location)locations.iterator().next()).getId(), (String)"az-1.region-a.geo-1");
        Assert.assertNotNull((Object)apiWhenServersExist.listNodes());
        Assert.assertEquals((int)apiWhenServersExist.listNodes().size(), (int)1);
        Assert.assertEquals((String)((ComputeMetadata)apiWhenServersExist.listNodes().iterator().next()).getId(), (String)"az-1.region-a.geo-1/52415800-8b69-11e0-9b19-734f000004d2");
        Assert.assertEquals((String)((ComputeMetadata)apiWhenServersExist.listNodes().iterator().next()).getName(), (String)"sample-server");
    }

    public void testDefaultTemplateOpenStack() throws Exception {
        ComputeService apiForOpenStack = (ComputeService)this.requestsSendResponses(this.defaultTemplateOpenStack);
        Template defaultTemplate = apiForOpenStack.templateBuilder().imageId("RegionOne/15").build();
        this.checkTemplate(defaultTemplate);
        this.checkTemplate(apiForOpenStack.templateBuilder().fromTemplate(defaultTemplate).build());
    }

    private void checkTemplate(Template defaultTemplate) {
        Assert.assertEquals((String)defaultTemplate.getImage().getId(), (String)"RegionOne/15");
        Assert.assertEquals((String)defaultTemplate.getImage().getProviderId(), (String)"15");
        Assert.assertEquals((String)defaultTemplate.getHardware().getId(), (String)"RegionOne/1");
        Assert.assertEquals((String)defaultTemplate.getHardware().getProviderId(), (String)"1");
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"RegionOne");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    public void testListServersWhenReponseIs404IsEmpty() throws Exception {
        HttpRequest listServers = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/servers/detail").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listServersResponse = HttpResponse.builder().statusCode(404).build();
        ComputeService apiWhenNoServersExist = (ComputeService)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, listServers, listServersResponse);
        Assert.assertTrue((boolean)apiWhenNoServersExist.listNodes().isEmpty());
    }

    @Test
    public void testCreateNodeWithGeneratedKeyPair() throws Exception {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder().putAll(this.defaultTemplateOpenStack);
        requestResponseMap.put((Object)this.list, (Object)this.notFound);
        requestResponseMap.put((Object)this.createWithPrefixOnGroup, (Object)this.securityGroupCreated);
        requestResponseMap.put((Object)this.createRuleForDefaultPort22, (Object)this.securityGroupRuleCreated);
        requestResponseMap.put((Object)this.getSecurityGroup, (Object)this.securityGroupWithPort22);
        requestResponseMap.put((Object)this.create, (Object)this.keyPairWithPrivateKey);
        requestResponseMap.put((Object)this.serverDetail, (Object)this.serverDetailResponse);
        HttpRequest createServerWithGeneratedKeyPair = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-1\",\"imageRef\":\"14\",\"flavorRef\":\"1\",\"key_name\":\"jclouds-test-0\",\"security_groups\":[{\"name\":\"jclouds-test\"}]}}", (String)"application/json"))).build();
        HttpResponse createdServer = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        requestResponseMap.put((Object)createServerWithGeneratedKeyPair, (Object)createdServer);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build(), (Module)new AbstractModule(){

            protected void configure() {
                final AtomicInteger suffix = new AtomicInteger();
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)new Supplier<String>(){

                    public String get() {
                        return suffix.getAndIncrement() + "";
                    }
                });
            }
        });
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)NovaTemplateOptions.Builder.blockUntilRunning((boolean)false).generateKeyPair(true)));
        Assert.assertNotNull((Object)node.getCredentials().getPrivateKey());
    }

    @Test
    public void testCreateNodeWhileUserSpecifiesKeyPair() throws Exception {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder().putAll(this.defaultTemplateOpenStack);
        requestResponseMap.put((Object)this.list, (Object)this.notFound);
        requestResponseMap.put((Object)this.createWithPrefixOnGroup, (Object)this.securityGroupCreated);
        requestResponseMap.put((Object)this.createRuleForDefaultPort22, (Object)this.securityGroupRuleCreated);
        requestResponseMap.put((Object)this.getSecurityGroup, (Object)this.securityGroupWithPort22);
        requestResponseMap.put((Object)this.serverDetail, (Object)this.serverDetailResponse);
        HttpRequest createServerWithSuppliedKeyPair = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-0\",\"imageRef\":\"14\",\"flavorRef\":\"1\",\"key_name\":\"fooPair\",\"security_groups\":[{\"name\":\"jclouds-test\"}]}}", (String)"application/json"))).build();
        HttpResponse createdServer = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        requestResponseMap.put((Object)createServerWithSuppliedKeyPair, (Object)createdServer);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build(), (Module)new AbstractModule(){

            protected void configure() {
                final AtomicInteger suffix = new AtomicInteger();
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)new Supplier<String>(){

                    public String get() {
                        return suffix.getAndIncrement() + "";
                    }
                });
            }
        });
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)NovaTemplateOptions.Builder.keyPairName((String)"fooPair").blockUntilRunning(false)));
        Assert.assertEquals((String)node.getCredentials().getPrivateKey(), null);
    }

    @Test
    public void testCreateNodeWhileUserSpecifiesKeyPairAndUserSpecifiedGroups() throws Exception {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder().putAll(this.defaultTemplateOpenStack);
        requestResponseMap.put((Object)this.list, (Object)this.notFound);
        requestResponseMap.put((Object)this.serverDetail, (Object)this.serverDetailResponse);
        HttpRequest createServerWithSuppliedKeyPairAndGroup = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://nova-api.openstack.org:9774/v1.1/3456/servers").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(NovaComputeServiceExpectTest.payloadFromStringWithContentType((String)"{\"server\":{\"name\":\"test-0\",\"imageRef\":\"14\",\"flavorRef\":\"1\",\"key_name\":\"fooPair\",\"security_groups\":[{\"name\":\"mygroup\"}]}}", (String)"application/json"))).build();
        HttpResponse createdServer = ((HttpResponse.Builder)HttpResponse.builder().statusCode(202).message("HTTP/1.1 202 Accepted").payload(this.payloadFromResourceWithContentType("/new_server.json", "application/json; charset=UTF-8"))).build();
        requestResponseMap.put((Object)createServerWithSuppliedKeyPairAndGroup, (Object)createdServer);
        ComputeService apiThatCreatesNode = (ComputeService)this.requestsSendResponses((Map)requestResponseMap.build(), (Module)new AbstractModule(){

            protected void configure() {
                final AtomicInteger suffix = new AtomicInteger();
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).toInstance((Object)new Supplier<String>(){

                    public String get() {
                        return suffix.getAndIncrement() + "";
                    }
                });
            }
        });
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)apiThatCreatesNode.createNodesInGroup("test", 1, (TemplateOptions)NovaTemplateOptions.Builder.keyPairName((String)"fooPair").securityGroupNames(new String[]{"mygroup"}).blockUntilRunning(false)));
        Assert.assertEquals((String)node.getCredentials().getPrivateKey(), null);
    }
}

