/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.openstack.nova.v2_0.compute.config.NovaComputeServiceContextModule;
import org.jclouds.openstack.nova.v2_0.compute.functions.ServerInZoneToNodeMetadata;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ServerInZone;
import org.jclouds.openstack.nova.v2_0.parse.ParseServerTest;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ServerInZoneToNodeMetadataTest")
public class ServerInZoneToNodeMetadataTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("openstack-nova").description("openstack-nova").build();
    Location zone = new LocationBuilder().id("az-1.region-a.geo-1").description("az-1.region-a.geo-1").scope(LocationScope.ZONE).parent(this.provider).build();
    Supplier<Map<String, Location>> locationIndex = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"az-1.region-a.geo-1", (Object)this.zone));
    GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);

    @Test
    public void testWhenNoHardwareOrImageMatchServerScopedIdsImageIdIsStillSet() {
        Hardware existingHardware = new HardwareBuilder().id("az-1.region-a.geo-1/FOOOOOOOO").providerId("FOOOOOOOO").location(this.zone).build();
        Image existingImage = new ImageBuilder().id("az-1.region-a.geo-1/FOOOOOOOO").operatingSystem(OperatingSystem.builder().family(OsFamily.LINUX).description("foobuntu").build()).providerId("FOOOOOOOO").description("foobuntu").location(this.zone).status(Image.Status.AVAILABLE).build();
        this.checkHardwareAndImageStatus(null, existingHardware, "az-1.region-a.geo-1/52415800-8b69-11e0-9b19-734f6f006e54", null, existingImage);
    }

    @Test
    public void testWhenNoHardwareAndImageMatchServerScopedIdsHardwareOperatingSystemAndImageIdAreSet() {
        Hardware existingHardware = new HardwareBuilder().id("az-1.region-a.geo-1/52415800-8b69-11e0-9b19-734f216543fd").providerId("52415800-8b69-11e0-9b19-734f216543fd").location(this.zone).build();
        Image existingImage = new ImageBuilder().id("az-1.region-a.geo-1/52415800-8b69-11e0-9b19-734f6f006e54").operatingSystem(OperatingSystem.builder().family(OsFamily.LINUX).description("foobuntu").build()).providerId("52415800-8b69-11e0-9b19-734f6f006e54").description("foobuntu").status(Image.Status.AVAILABLE).location(this.zone).build();
        this.checkHardwareAndImageStatus(existingHardware, existingHardware, existingImage.getId(), existingImage.getOperatingSystem(), existingImage);
    }

    private void checkHardwareAndImageStatus(Hardware expectedHardware, Hardware existingHardware, String expectedImageId, OperatingSystem expectedOs, Image existingImage) {
        ImmutableSet images = existingImage == null ? ImmutableSet.of() : ImmutableSet.of((Object)existingImage);
        ImmutableSet hardwares = existingHardware == null ? ImmutableSet.of() : ImmutableSet.of((Object)existingHardware);
        Server serverToConvert = new ParseServerTest().expected();
        ServerInZone serverInZoneToConvert = new ServerInZone(serverToConvert, "az-1.region-a.geo-1");
        ServerInZoneToNodeMetadata converter = new ServerInZoneToNodeMetadata(NovaComputeServiceContextModule.toPortableNodeStatus, this.locationIndex, Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)hardwares), this.namingConvention);
        NodeMetadata convertedNodeMetadata = converter.apply(serverInZoneToConvert);
        Assert.assertEquals((String)serverInZoneToConvert.slashEncode(), (String)convertedNodeMetadata.getId());
        Assert.assertEquals((String)serverToConvert.getId(), (String)convertedNodeMetadata.getProviderId());
        Assert.assertEquals((Object)convertedNodeMetadata.getLocation().getScope(), (Object)LocationScope.HOST);
        Assert.assertEquals((String)convertedNodeMetadata.getLocation().getId(), (String)"e4d909c290d0fb1ca068ffaddf22cbd0");
        Assert.assertEquals((Object)convertedNodeMetadata.getLocation().getParent(), ((Map)this.locationIndex.get()).get("az-1.region-a.geo-1"));
        Assert.assertEquals((String)serverToConvert.getName(), (String)convertedNodeMetadata.getName());
        Assert.assertEquals((String)convertedNodeMetadata.getGroup(), (String)"sample");
        Assert.assertEquals((String)convertedNodeMetadata.getImageId(), (String)expectedImageId);
        Assert.assertEquals((Object)convertedNodeMetadata.getOperatingSystem(), (Object)expectedOs);
        Assert.assertEquals((Object)convertedNodeMetadata.getHardware(), (Object)expectedHardware);
        Assert.assertEquals(NovaComputeServiceContextModule.toPortableNodeStatus.get(serverToConvert.getStatus()), (Object)convertedNodeMetadata.getStatus());
        Assert.assertNotNull((Object)convertedNodeMetadata.getPrivateAddresses());
        Assert.assertEquals((Set)convertedNodeMetadata.getPrivateAddresses(), (Set)ImmutableSet.of((Object)"10.176.42.16"));
        Assert.assertNotNull((Object)convertedNodeMetadata.getPublicAddresses());
        Assert.assertEquals((Set)convertedNodeMetadata.getPublicAddresses(), (Set)ImmutableSet.of((Object)"67.23.10.132", (Object)"67.23.10.131"));
        Assert.assertNotNull((Object)convertedNodeMetadata.getUserMetadata());
        Assert.assertEquals((Map)convertedNodeMetadata.getUserMetadata(), (Map)ImmutableMap.of((Object)"Server Label", (Object)"Web Head 1", (Object)"Image Version", (Object)"2.1"));
        URI expectedURI = URI.create("http://servers.api.openstack.org/v1.1/1234/servers/52415800-8b69-11e0-9b19-734f6f006e54");
        Assert.assertEquals((Object)convertedNodeMetadata.getUri(), (Object)expectedURI);
    }

    @Test
    public void testNewServerWithoutHostIdSetsZoneAsLocation() {
        ImmutableSet images = ImmutableSet.of();
        ImmutableSet hardwares = ImmutableSet.of();
        Server serverToConvert = this.expectedServer();
        ServerInZone serverInZoneToConvert = new ServerInZone(serverToConvert, "az-1.region-a.geo-1");
        ServerInZoneToNodeMetadata converter = new ServerInZoneToNodeMetadata(NovaComputeServiceContextModule.toPortableNodeStatus, this.locationIndex, Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)hardwares), this.namingConvention);
        NodeMetadata convertedNodeMetadata = converter.apply(serverInZoneToConvert);
        Assert.assertEquals((String)serverInZoneToConvert.slashEncode(), (String)convertedNodeMetadata.getId());
        Assert.assertEquals((String)serverToConvert.getId(), (String)convertedNodeMetadata.getProviderId());
        Assert.assertEquals((Object)convertedNodeMetadata.getLocation(), (Object)this.zone);
        URI expectedURI = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/37936628937291/servers/71752");
        Assert.assertEquals((Object)convertedNodeMetadata.getUri(), (Object)expectedURI);
    }

    public Server expectedServer() {
        return ((Server.Builder)((Server.Builder)((Server.Builder)Server.builder().id("71752")).uuid("47491020-6a78-4f63-9475-23195ac4515c").tenantId("37936628937291").userId("54297837463082").name("test-e92")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-19T06:21:13Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-19T06:21:13Z")).status(Server.Status.BUILD).image(Resource.builder().id("1241").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/images/1241"))}).build()).flavor(Resource.builder().id("100").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/flavors/100"))}).build()).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/37936628937291/servers/71752")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/servers/71752"))})).build();
    }
}

