/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.BackupType;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.extensions.ServerAdminApi;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.jclouds.openstack.nova.v2_0.options.CreateBackupOfServerOptions;
import org.jclouds.openstack.v2_0.features.ExtensionApi;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AdminActionsApiLiveTest", singleThreaded=true)
public class AdminActionsApiLiveTest
extends BaseNovaApiLiveTest {
    private ImageApi imageApi;
    private ServerApi serverApi;
    private ExtensionApi extensionApi;
    private Optional<? extends ServerAdminApi> apiOption;
    private String zone;
    private String testServerId;
    private String backupImageId;

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
        this.serverApi = ((NovaApi)this.api).getServerApiForZone(this.zone);
        this.extensionApi = ((NovaApi)this.api).getExtensionApiForZone(this.zone);
        this.imageApi = ((NovaApi)this.api).getImageApiForZone(this.zone);
        this.apiOption = ((NovaApi)this.api).getServerAdminExtensionForZone(this.zone);
        if (this.apiOption.isPresent()) {
            this.testServerId = this.createServerInZone(this.zone).getId();
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.apiOption.isPresent()) {
            if (this.testServerId != null) {
                Assert.assertTrue((boolean)((NovaApi)this.api).getServerApiForZone(this.zone).delete(this.testServerId));
            }
            if (this.backupImageId != null) {
                this.imageApi.delete(this.backupImageId);
            }
        }
        super.tearDown();
    }

    protected void skipOnAdminExtensionAbsent() {
        if (!this.apiOption.isPresent()) {
            throw new SkipException("Test depends on ServerAdminApi extension");
        }
    }

    @AfterMethod(alwaysRun=true)
    public void ensureServerIsActiveAgain() {
        if (this.apiOption.isPresent()) {
            this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.ACTIVE);
        }
    }

    public void testSuspendAndResume() {
        this.skipOnAdminExtensionAbsent();
        ServerAdminApi api = (ServerAdminApi)this.apiOption.get();
        try {
            api.resume(this.testServerId);
            Assert.fail((String)"Resumed an active server!");
        }
        catch (HttpResponseException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)api.suspend(this.testServerId));
        this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.SUSPENDED);
        try {
            api.suspend(this.testServerId);
            Assert.fail((String)"Suspended an already suspended server!");
        }
        catch (HttpResponseException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)api.resume(this.testServerId));
        this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.ACTIVE);
        try {
            api.resume(this.testServerId);
            Assert.fail((String)"Resumed an already resumed server!");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
    }

    public void testLockAndUnlock() {
        this.skipOnAdminExtensionAbsent();
        ServerAdminApi api = (ServerAdminApi)this.apiOption.get();
        Assert.assertTrue((boolean)api.unlock(this.testServerId));
        Assert.assertTrue((boolean)api.unlock(this.testServerId));
        Assert.assertTrue((boolean)api.lock(this.testServerId));
        Assert.assertTrue((boolean)api.lock(this.testServerId));
        Assert.assertTrue((boolean)api.unlock(this.testServerId));
        Assert.assertTrue((boolean)api.unlock(this.testServerId));
    }

    public void testResetNetworkAndInjectNetworkInfo() {
        this.skipOnAdminExtensionAbsent();
        ServerAdminApi api = (ServerAdminApi)this.apiOption.get();
        Assert.assertTrue((boolean)api.resetNetwork(this.testServerId));
        Assert.assertTrue((boolean)api.injectNetworkInfo(this.testServerId));
    }

    @Test
    public void testPauseAndUnpause() {
        this.skipOnAdminExtensionAbsent();
        ServerAdminApi api = (ServerAdminApi)this.apiOption.get();
        try {
            api.unpause(this.testServerId);
            Assert.fail((String)"Unpaused active server!");
        }
        catch (HttpResponseException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)api.pause(this.testServerId));
        this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.PAUSED);
        try {
            api.pause(this.testServerId);
            Assert.fail((String)"paused a paused server!");
        }
        catch (HttpResponseException e) {
            // empty catch block
        }
        Assert.assertTrue((boolean)api.unpause(this.testServerId));
        this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.ACTIVE);
        try {
            api.unpause(this.testServerId);
            Assert.fail((String)"Unpaused a server we just unpaused!");
        }
        catch (HttpResponseException httpResponseException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateBackupOfServer() throws InterruptedException {
        this.skipOnAdminExtensionAbsent();
        this.backupImageId = ((ServerAdminApi)this.apiOption.get()).createBackup(this.testServerId, "jclouds-test-backup", BackupType.DAILY, 0, new CreateBackupOfServerOptions[]{CreateBackupOfServerOptions.Builder.metadata((Map)ImmutableMap.of((Object)"test", (Object)"metadata"))});
        Assert.assertNotNull((Object)this.backupImageId);
        if (this.extensionApi.get("OS-EXT-STS") == null) {
            Thread.sleep(30000L);
        }
        this.blockUntilServerInState(this.testServerId, this.serverApi, Server.Status.ACTIVE);
        Image backupImage = this.imageApi.get(this.backupImageId);
        Assert.assertEquals((String)backupImage.getId(), (String)this.backupImageId);
    }
}

