/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.extensions.HostAdministrationApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="HostAdministrationApiLiveTest", singleThreaded=true)
public class HostAdministrationApiLiveTest
extends BaseNovaApiLiveTest {
    private Optional<? extends HostAdministrationApi> optApi = Optional.absent();
    Predicate<Host> isComputeHost = new Predicate<Host>(){

        public boolean apply(Host input) {
            return Objects.equal((Object)"compute", (Object)input.getService());
        }
    };

    @Override
    @BeforeGroups(groups={"integration", "live"})
    public void setup() {
        super.setup();
        if (this.identity.endsWith(":admin")) {
            String zone = (String)Iterables.getLast((Iterable)((NovaApi)this.api).getConfiguredZones(), (Object)"nova");
            this.optApi = ((NovaApi)this.api).getHostAdministrationExtensionForZone(zone);
        }
    }

    public void testListAndGet() throws Exception {
        if (this.optApi.isPresent()) {
            HostAdministrationApi api = (HostAdministrationApi)this.optApi.get();
            ImmutableSet hosts = api.list().toSet();
            Assert.assertNotNull((Object)hosts);
            for (Host host : hosts) {
                for (HostResourceUsage usage : api.listResourceUsage(host.getName())) {
                    Assert.assertEquals((String)usage.getHost(), (String)host.getName());
                    Assert.assertNotNull((Object)usage);
                }
            }
        }
    }

    @Test(enabled=false)
    public void testEnableDisable() throws Exception {
        if (this.optApi.isPresent()) {
            HostAdministrationApi api = (HostAdministrationApi)this.optApi.get();
            Host host = (Host)Iterables.find((Iterable)api.list(), this.isComputeHost);
            Assert.assertTrue((boolean)api.disable(host.getName()));
            Assert.assertTrue((boolean)api.enable(host.getName()));
        }
    }

    @Test(enabled=false)
    public void testMaintenanceMode() throws Exception {
        if (this.optApi.isPresent()) {
            HostAdministrationApi api = (HostAdministrationApi)this.optApi.get();
            Host host = (Host)Iterables.find((Iterable)api.list(), this.isComputeHost);
            Assert.assertTrue((boolean)api.startMaintenance(host.getName()));
            Assert.assertTrue((boolean)api.stopMaintenance(host.getName()));
        }
    }

    @Test(enabled=false)
    public void testReboot() throws Exception {
        if (this.optApi.isPresent()) {
            HostAdministrationApi api = (HostAdministrationApi)this.optApi.get();
            Host host = (Host)Iterables.find((Iterable)api.list(), this.isComputeHost);
            Assert.assertTrue((boolean)api.reboot(host.getName()));
        }
    }

    @Test(enabled=false)
    public void testShutdownAndStartup() throws Exception {
        if (this.optApi.isPresent()) {
            HostAdministrationApi api = (HostAdministrationApi)this.optApi.get();
            Host host = (Host)Iterables.find((Iterable)api.list(), this.isComputeHost);
            Assert.assertTrue((boolean)api.shutdown(host.getName()));
            Assert.assertTrue((boolean)api.startup(host.getName()));
        }
    }
}

