/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.nova.v2_0.extensions.HostAggregateApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HostAggregateApiExpectTest")
public class HostAggregateApiExpectTest
extends BaseNovaApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testList() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_list.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        HostAggregate result = (HostAggregate)Iterables.getOnlyElement((Iterable)api.list());
        Assert.assertEquals((Object)result, (Object)this.exampleHostAggregate());
    }

    public void testGet() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_with_host_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.get("1"), (Object)this.exampleHostAggregateWithHost());
    }

    public void testGetFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertNull((Object)api.get("1"));
    }

    public void testCreateAggregate() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"aggregate\":{\"name\":\"ubuntu1\",\"availability_zone\":\"nova\"}}", (String)"application/json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.createInAvailabilityZone("ubuntu1", "nova"), (Object)this.exampleHostAggregate());
    }

    public void testDeleteAggregate() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(200).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertTrue((boolean)api.delete("1"));
    }

    public void testDeleteAggregateFailNotFound() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertFalse((boolean)api.delete("1"));
    }

    public void testUpdateName() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"aggregate\":{\"name\":\"newaggregatename\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.updateName("1", "newaggregatename"), (Object)this.exampleHostAggregate());
    }

    public void testUpdateAvailabilityZone() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"aggregate\":{\"availability_zone\":\"zone1\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.updateAvailabilityZone("1", "zone1"), (Object)this.exampleHostAggregate());
    }

    public void testAddHost() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1/action");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"add_host\":{\"host\":\"ubuntu\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.addHost("1", "ubuntu"), (Object)this.exampleHostAggregate());
    }

    public void testRemoveHost() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1/action");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"remove_host\":{\"host\":\"ubuntu\"}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.removeHost("1", "ubuntu"), (Object)this.exampleHostAggregate());
    }

    public void testSetMetadata() {
        URI endpoint = URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-aggregates/1/action");
        HostAggregateApi api = (HostAggregateApi)((NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(HostAggregateApiExpectTest.payloadFromStringWithContentType((String)"{\"set_metadata\":{\"metadata\":{\"mykey\":\"some value or other\"}}}", (String)"application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/host_aggregate_details.json"))).build())).getHostAggregateExtensionForZone("az-1.region-a.geo-1").get();
        Assert.assertEquals((Object)api.setMetadata("1", (Map)ImmutableMap.of((Object)"mykey", (Object)"some value or other")), (Object)this.exampleHostAggregate());
    }

    public HostAggregate exampleHostAggregate() {
        return HostAggregate.builder().name("jclouds-test-a").availabilityZone("nova").created(this.dateService.iso8601SecondsDateParse("2012-05-11 11:40:17")).updated(this.dateService.iso8601SecondsDateParse("2012-05-11 11:46:44")).state("created").id("1").metadata((Map)ImmutableMap.of((Object)"somekey", (Object)"somevalue", (Object)"anotherkey", (Object)"another val")).build();
    }

    public HostAggregate exampleHostAggregateWithHost() {
        return this.exampleHostAggregate().toBuilder().hosts(new String[]{"ubuntu"}).build();
    }
}

