/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseKeyPairListTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseKeyPairTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="KeyPairApiExpectTest")
public class KeyPairApiExpectTest
extends BaseNovaApiExpectTest {
    public void testListKeyPairsWhenResponseIs2xx() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-keypairs").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/keypair_list.json"))).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        Assert.assertEquals((Set)apiWhenServersExist.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-1.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-3.region-a.geo-1"));
        Assert.assertEquals((String)((KeyPairApi)apiWhenServersExist.getKeyPairExtensionForZone("az-1.region-a.geo-1").get()).list().toString(), (String)new ParseKeyPairListTest().expected().toString());
    }

    public void testListKeyPairsWhenResponseIs404() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-keypairs").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse listResponse = HttpResponse.builder().statusCode(404).build();
        NovaApi apiWhenNoServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        Assert.assertTrue((boolean)((KeyPairApi)apiWhenNoServersExist.getKeyPairExtensionForZone("az-1.region-a.geo-1").get()).list().isEmpty());
    }

    public void testCreateKeyPair() throws Exception {
        HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-keypairs").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(KeyPairApiExpectTest.payloadFromStringWithContentType((String)"{\"keypair\":{\"name\":\"testkeypair\"}}", (String)"application/json"))).build();
        HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/keypair_created.json"))).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, create, createResponse);
        Assert.assertEquals((String)((KeyPairApi)apiWhenServersExist.getKeyPairExtensionForZone("az-1.region-a.geo-1").get()).create("testkeypair").toString(), (String)new ParseKeyPairTest().expected().toString());
    }

    public void testCreateKeyPairWithPublicKey() throws Exception {
        HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-keypairs").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(KeyPairApiExpectTest.payloadFromStringWithContentType((String)"{\"keypair\":{\"name\":\"testkeypair\",\"public_key\":\"ssh-rsa AAAXB3NzaC1yc2EAAAADAQABAAAAgQDFNyGjgs6c9akgmZ2ou/fJf7Pdrc23hC95/gM/33OrG4GZABACE4DTioa/PGN+7rHv9YUavUCtXrWayhGniKq/wCuI5fo5TO4AmDNv7/sCGHIHFumADSIoLx0vFhGJIetXEWxL9r0lfFC7//6yZM2W3KcGjbMtlPXqBT9K9PzdyQ== nova@nv-aw2az1-api0001\n\"}}", (String)"application/json"))).build();
        HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/keypair_created.json"))).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, create, createResponse);
        Assert.assertEquals((String)((KeyPairApi)apiWhenServersExist.getKeyPairExtensionForZone("az-1.region-a.geo-1").get()).createWithPublicKey("testkeypair", "ssh-rsa AAAXB3NzaC1yc2EAAAADAQABAAAAgQDFNyGjgs6c9akgmZ2ou/fJf7Pdrc23hC95/gM/33OrG4GZABACE4DTioa/PGN+7rHv9YUavUCtXrWayhGniKq/wCuI5fo5TO4AmDNv7/sCGHIHFumADSIoLx0vFhGJIetXEWxL9r0lfFC7//6yZM2W3KcGjbMtlPXqBT9K9PzdyQ== nova@nv-aw2az1-api0001\n").toString(), (String)new ParseKeyPairTest().expected().toString());
    }

    public void testDeleteKeyPair() throws Exception {
        HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-keypairs/testkeypair").addHeader("Accept", new String[]{"*/*"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse deleteResponse = HttpResponse.builder().statusCode(202).build();
        NovaApi apiWhenServersExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, delete, deleteResponse);
        Assert.assertTrue((boolean)((KeyPairApi)apiWhenServersExist.getKeyPairExtensionForZone("az-1.region-a.geo-1").get()).delete("testkeypair"));
    }
}

