/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Atomics;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.jclouds.openstack.nova.v2_0.parse.ParseSecurityGroupListTest;
import org.jclouds.openstack.nova.v2_0.predicates.FindSecurityGroupWithNameAndReturnTrue;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FindSecurityGroupWithNameAndReturnTrueExpectTest")
public class FindSecurityGroupWithNameAndReturnTrueExpectTest
extends BaseNovaApiExpectTest {
    public void testUpdateReferenceWhenSecurityGroupListContainsGroupName() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_list.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        FindSecurityGroupWithNameAndReturnTrue predicate = new FindSecurityGroupWithNameAndReturnTrue(apiWhenSecurityGroupsExist);
        AtomicReference securityGroupInZoneRef = Atomics.newReference((Object)ZoneAndName.fromZoneAndName((String)"az-1.region-a.geo-1", (String)"name1"));
        Assert.assertTrue((boolean)predicate.apply(securityGroupInZoneRef));
        Assert.assertEquals((String)((ZoneAndName)securityGroupInZoneRef.get()).toString(), (String)new SecurityGroupInZone((SecurityGroup)Iterables.getOnlyElement((Iterable)new ParseSecurityGroupListTest().expected()), "az-1.region-a.geo-1").toString());
    }

    public void testDoesNotUpdateReferenceWhenSecurityGroupListMissingGroupName() throws Exception {
        HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("https://az-1.region-a.geo-1.compute.hpcloudsvc.com/v1.1/3456/os-security-groups")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Accept", (Object)"application/json").put((Object)"X-Auth-Token", (Object)this.authToken).build())).build();
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/securitygroup_list.json"))).build();
        NovaApi apiWhenSecurityGroupsExist = (NovaApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.extensionsOfNovaRequest, this.extensionsOfNovaResponse, list, listResponse);
        FindSecurityGroupWithNameAndReturnTrue predicate = new FindSecurityGroupWithNameAndReturnTrue(apiWhenSecurityGroupsExist);
        ZoneAndName zoneAndGroup = ZoneAndName.fromZoneAndName((String)"az-1.region-a.geo-1", (String)"name2");
        AtomicReference securityGroupInZoneRef = Atomics.newReference((Object)zoneAndGroup);
        Assert.assertFalse((boolean)predicate.apply(securityGroupInZoneRef));
        Assert.assertEquals(securityGroupInZoneRef.get(), (Object)zoneAndGroup);
    }
}

