/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.handlers;

import com.google.common.base.Ticker;
import com.google.gson.Gson;
import java.util.concurrent.TimeUnit;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.fallbacks.HeaderToRetryAfterException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.Json;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.openstack.nova.v2_0.functions.OverLimitParser;
import org.jclouds.openstack.nova.v2_0.handlers.NovaErrorHandler;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.RetryAfterException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NovaErrorHandlerTest", singleThreaded=true)
public class NovaErrorHandlerTest {
    private HttpCommand command;
    HttpResponse noFixedIps = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("HTTP/1.1 400 Bad Request").payload("{\"badRequest\": {\"message\": \"instance |71554| has no fixed_ips. unable to associate floating ip\", \"code\": 400}}")).build();
    HttpResponse alreadyExists = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("HTTP/1.1 400 Bad Request").payload("{\"badRequest\": {\"message\": \"Server with the name 'test' already exists\", \"code\": 400}}")).build();
    HttpResponse quotaExceeded = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("HTTP/1.1 400 Bad Request").payload("{\"badRequest\": {\"message\": \"AddressLimitExceeded: Address quota exceeded. You cannot create any more addresses\", \"code\": 400}}")).build();
    HttpResponse tooLarge = ((HttpResponse.Builder)HttpResponse.builder().statusCode(413).message("HTTP/1.1 413 Request Entity Too Large").payload("{\"badRequest\": {\"message\": \"Volume quota exceeded. You cannot create a volume of size 1G\", \"code\": 413, \"retryAfter\": 0}}")).build();
    HttpResponse retryAt = ((HttpResponse.Builder)HttpResponse.builder().statusCode(413).message("HTTP/1.1 413 Request Entity Too Large").payload("{ 'overLimit' : { 'code' : 413, 'message' : 'OverLimit Retry...',  'details' : 'Error Details...', 'retryAt' : '2012-11-14T21:51:28UTC' }}")).build();
    HttpResponse retryAfter = ((HttpResponse.Builder)HttpResponse.builder().statusCode(413).message("HTTP/1.1 413 Request Entity Too Large").payload("{ 'overLimit': { 'message': 'This request was rate-limited.',  'retryAfter': '54',  'details': 'Only 1 POST request(s) can be made to \\'*\\' every minute.' }}")).build();
    HttpResponse retryAfterTrumps = ((HttpResponse.Builder)HttpResponse.builder().statusCode(413).message("HTTP/1.1 413 Request Entity Too Large").payload("{ 'overLimit': { 'message': 'This request was rate-limited.',  'retryAfter': '54',  'retryAt' : '2012-11-14T21:51:28UTC', 'details': 'Only 1 POST request(s) can be made to \\'*\\' every minute.' }}")).build();
    HttpResponse badRetryAt = ((HttpResponse.Builder)HttpResponse.builder().statusCode(413).message("HTTP/1.1 413 Request Entity Too Large").payload("{ 'overLimit' : { 'code' : 413, 'message' : 'OverLimit Retry...',  'details' : 'Error Details...', 'retryAt' : '2012-11-~~~:51:28UTC' }}")).build();
    DateCodec iso8601Seconds = new DateServiceDateCodecFactory.DateServiceIso8601SecondsCodec((DateService)new SimpleDateFormatDateService());
    Ticker y2k = new Ticker(){

        public long read() {
            return TimeUnit.MILLISECONDS.toNanos(NovaErrorHandlerTest.this.iso8601Seconds.toDate("2012-11-14T20:51:28UTC").getTime());
        }
    };
    NovaErrorHandler fn = new NovaErrorHandler(HeaderToRetryAfterException.create((Ticker)this.y2k, (DateCodec)this.iso8601Seconds), new OverLimitParser((Json)new GsonWrapper(new Gson())));

    @BeforeTest
    void setupCommand() {
        this.command = this.command();
    }

    @Test
    public void test401MakesAuthorizationException() {
        this.fn.handleError(this.command, HttpResponse.builder().statusCode(401).message("Unauthorized").build());
        Assert.assertEquals(this.command.getException().getClass(), AuthorizationException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"POST https://nova/v1.1/servers HTTP/1.1 -> HTTP/1.1 401 Unauthorized");
    }

    @Test
    public void test404MakesResourceNotFoundException() {
        this.fn.handleError(this.command, HttpResponse.builder().statusCode(404).message("Not Found").build());
        Assert.assertEquals(this.command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"POST https://nova/v1.1/servers HTTP/1.1 -> HTTP/1.1 404 Not Found");
    }

    @Test
    public void test400MakesIllegalStateExceptionOnQuotaExceededOnNoFixedIps() {
        this.fn.handleError(this.command, this.noFixedIps);
        Assert.assertEquals(this.command.getException().getClass(), IllegalStateException.class);
        Assert.assertEquals((Object)this.command.getException().getMessage(), (Object)this.noFixedIps.getPayload().getRawContent());
    }

    @Test
    public void test400MakesIllegalStateExceptionOnAlreadyExists() {
        this.fn.handleError(this.command, this.alreadyExists);
        Assert.assertEquals(this.command.getException().getClass(), IllegalStateException.class);
        Assert.assertEquals((Object)this.command.getException().getMessage(), (Object)this.alreadyExists.getPayload().getRawContent());
    }

    @Test
    public void test400MakesInsufficientResourcesExceptionOnQuotaExceeded() {
        this.fn.handleError(this.command, this.quotaExceeded);
        Assert.assertEquals(this.command.getException().getClass(), InsufficientResourcesException.class);
        Assert.assertEquals((Object)this.command.getException().getMessage(), (Object)this.quotaExceeded.getPayload().getRawContent());
    }

    @Test
    public void test413MakesInsufficientResourcesException() {
        this.fn.handleError(this.command, this.tooLarge);
        Assert.assertEquals(this.command.getException().getClass(), InsufficientResourcesException.class);
        Assert.assertEquals((Object)this.command.getException().getMessage(), (Object)this.tooLarge.getPayload().getRawContent());
    }

    @Test
    public void test413WithRetryAtExceptionParsesDelta() {
        this.fn.handleError(this.command, this.retryAt);
        Assert.assertEquals(this.command.getException().getClass(), RetryAfterException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"retry in 3600 seconds");
    }

    @Test
    public void test413WithRetryAfterExceptionFolsom() {
        this.fn.handleError(this.command, this.retryAfter);
        Assert.assertEquals(this.command.getException().getClass(), RetryAfterException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"retry in 54 seconds");
    }

    @Test
    public void test413WithRetryAfterTrumpsRetryAt() {
        this.fn.handleError(this.command, this.retryAfterTrumps);
        Assert.assertEquals(this.command.getException().getClass(), RetryAfterException.class);
        Assert.assertEquals((String)this.command.getException().getMessage(), (String)"retry in 54 seconds");
    }

    @Test
    public void test413WithBadRetryAtFormatFallsBack() {
        this.fn.handleError(this.command, this.badRetryAt);
        Assert.assertEquals(this.command.getException().getClass(), InsufficientResourcesException.class);
        Assert.assertEquals((Object)this.command.getException().getMessage(), (Object)this.badRetryAt.getPayload().getRawContent());
    }

    private HttpCommand command() {
        return new HttpCommand(HttpRequest.builder().method("POST").endpoint("https://nova/v1.1/servers").build());
    }
}

