/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseExtensionTest")
public class ParseExtensionTest
extends BaseItemParserTest<Extension> {
    public String resource() {
        return "/extension_details.json";
    }

    @SelectJson(value={"extension"})
    @Consumes(value={"application/json"})
    public Extension expected() {
        return ((Extension.Builder)((Extension.Builder)Extension.builder().alias("RS-PIE").name("Public Image Extension")).namespace(URI.create("http://docs.rackspacecloud.com/servers/api/ext/pie/v1.0")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-01-22T13:25:27-06:00")).description("Adds the capability to share an image with other users.").links((Set)ImmutableSet.of((Object)Link.create((Link.Relation)Link.Relation.DESCRIBEDBY, (String)"application/pdf", (URI)URI.create("http://docs.rackspacecloud.com/servers/api/ext/cs-pie-20111111.pdf")), (Object)Link.create((Link.Relation)Link.Relation.DESCRIBEDBY, (String)"application/vnd.sun.wadl+xml", (URI)URI.create("http://docs.rackspacecloud.com/servers/api/ext/cs-pie.wadl"))))).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

