/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.json.BaseSetParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseFlavorListTest")
public class ParseFlavorListTest
extends BaseSetParserTest<Resource> {
    public String resource() {
        return "/flavor_list.json";
    }

    @SelectJson(value={"flavors"})
    @Consumes(value={"application/json"})
    public Set<Resource> expected() {
        return ImmutableSet.of((Object)Resource.builder().id("52415800-8b69-11e0-9b19-734f1195ff37").name("256 MB Server").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/flavors/52415800-8b69-11e0-9b19-734f1195ff37")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/flavors/52415800-8b69-11e0-9b19-734f1195ff37"))}).build(), (Object)Resource.builder().id("52415800-8b69-11e0-9b19-734f216543fd").name("512 MB Server").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/flavors/52415800-8b69-11e0-9b19-734f216543fd")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/flavors/52415800-8b69-11e0-9b19-734f216543fd"))}).build());
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

