/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseImageTest")
public class ParseImageTest
extends BaseItemParserTest<Image> {
    public String resource() {
        return "/image_details.json";
    }

    @SelectJson(value={"image"})
    @Consumes(value={"application/json"})
    public Image expected() {
        return ((Image.Builder)((Image.Builder)((Image.Builder)Image.builder().id("52415800-8b69-11e0-9b19-734f5736d2a2")).name("My Server Backup")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-10-10T12:00:00Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2010-08-10T12:00:00Z")).tenantId("12345").userId("joe").status(Image.Status.SAVING).progress(80).minDisk(5).minRam(256).metadata((Map)new ImmutableMap.Builder().put((Object)"ImageType", (Object)"Gold").put((Object)"ImageVersion", (Object)"1.5").build()).server(Resource.builder().id("52415800-8b69-11e0-9b19-734f335aa7b3").name("null").links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/servers/52415800-8b69-11e0-9b19-734f335aa7b3")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/servers/52415800-8b69-11e0-9b19-734f335aa7b3"))}).build()).links((Set)ImmutableSet.of((Object)Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("http://servers.api.openstack.org/v1.1/1234/images/52415800-8b69-11e0-9b19-734f5736d2a2")), (Object)Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("http://servers.api.openstack.org/1234/images/52415800-8b69-11e0-9b19-734f5736d2a2"))))).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

