/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseServerTest")
public class ParseServerWithInternetAddressesTest
extends BaseItemParserTest<Server> {
    public String resource() {
        return "/server_details_openstack.json";
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public Server expected() {
        return ((Server.Builder)((Server.Builder)((Server.Builder)Server.builder().id("1459")).uuid("2443c9c7-9791-412e-ac09-a6d55ec25335").tenantId("37").userId("508151008").name("mygroup-72c")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-23T01:30:26Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-23T01:30:26Z")).hostId("881706597197955ac7cc4b353bc7ec884e13fa280de9cc82057796cb").status(Server.Status.ACTIVE).image(Resource.builder().id("14").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://nova-api.openstack.org:9774/37/images/14"))}).build()).flavor(Resource.builder().id("1").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://nova-api.openstack.org:9774/37/flavors/1"))}).build()).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("https://nova-api.openstack.org:9774/v1.1/37/servers/1459")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://nova-api.openstack.org:9774/37/servers/1459"))})).addresses((Multimap)ImmutableMultimap.of((Object)"internet", (Object)Address.createV4((String)"8.21.28.47"))).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

