/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.parse;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseCreatedServerTest")
public class PublicIpsInPrivateAddressBlockExpectTest
extends BaseItemParserTest<Server> {
    public String resource() {
        return "/server_public_ip_in_private.json";
    }

    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    public Server expected() {
        return ((Server.Builder)((Server.Builder)((Server.Builder)Server.builder().id("59662")).hostId("cb0d9e5004bef8c21270a0b09f7624f4c387f3a523f3aaa4c5694a61").uuid("7aed8e05-1daf-476a-87b2-640e8f7dcafd").tenantId("37936628937291").userId("54297837463082").name("hpcloud-computes-38d")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-22T22:11:55Z")).created(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-03-22T22:11:19Z")).status(Server.Status.ACTIVE).keyName("jclouds_hpcloud-computes_77").image(Resource.builder().id("229").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/images/229"))}).build()).flavor(Resource.builder().id("100").links(new Link[]{Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/flavors/100"))}).build()).metadata((Map)ImmutableMap.of((Object)"Name", (Object)"hpcloud-computes")).addresses((Multimap)ImmutableMultimap.builder().putAll((Object)"private", (Object[])new Address[]{Address.createV4((String)"10.6.39.189"), Address.createV4((String)"15.185.181.94")}).build()).links(new Link[]{Link.create((Link.Relation)Link.Relation.SELF, (URI)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/v1.1/37936628937291/servers/59662")), Link.create((Link.Relation)Link.Relation.BOOKMARK, (URI)URI.create("https://az-2.region-a.geo-1.compute.hpcloudsvc.com/37936628937291/servers/59662"))})).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new NovaParserModule(), new GsonModule()});
    }
}

