/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Ingress;
import org.jclouds.openstack.nova.v2_0.domain.IpProtocol;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.predicates.SecurityGroupPredicates;

@Singleton
public class CreateSecurityGroupIfNeeded
implements Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;

    @Inject
    public CreateSecurityGroupIfNeeded(NovaApi novaApi) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
    }

    public SecurityGroupInZone apply(ZoneSecurityGroupNameAndPorts zoneSecurityGroupNameAndPorts) {
        Preconditions.checkNotNull((Object)zoneSecurityGroupNameAndPorts, (Object)"zoneSecurityGroupNameAndPorts");
        String zoneId = zoneSecurityGroupNameAndPorts.getZone();
        Optional<? extends SecurityGroupApi> api = this.novaApi.getSecurityGroupExtensionForZone(zoneId);
        Preconditions.checkArgument((boolean)api.isPresent(), (String)"Security groups are required, but the extension is not availablein zone %s!", (Object[])new Object[]{zoneId});
        this.logger.debug(">> creating securityGroup %s", new Object[]{zoneSecurityGroupNameAndPorts});
        try {
            SecurityGroup securityGroup = ((SecurityGroupApi)api.get()).createWithDescription(zoneSecurityGroupNameAndPorts.getName(), zoneSecurityGroupNameAndPorts.getName());
            this.logger.debug("<< created securityGroup(%s)", new Object[]{securityGroup});
            for (int port : zoneSecurityGroupNameAndPorts.getPorts()) {
                this.authorizeGroupToItselfAndAllIPsToTCPPort((SecurityGroupApi)api.get(), securityGroup, port);
            }
            return new SecurityGroupInZone(((SecurityGroupApi)api.get()).get(securityGroup.getId()), zoneId);
        }
        catch (IllegalStateException e) {
            this.logger.trace("<< trying to find securityGroup(%s): %s", new Object[]{zoneSecurityGroupNameAndPorts, e.getMessage()});
            SecurityGroup group = (SecurityGroup)Iterables.find(((SecurityGroupApi)api.get()).list(), SecurityGroupPredicates.nameEquals(zoneSecurityGroupNameAndPorts.getName()));
            this.logger.debug("<< reused securityGroup(%s)", new Object[]{group.getId()});
            return new SecurityGroupInZone(group, zoneId);
        }
    }

    private void authorizeGroupToItselfAndAllIPsToTCPPort(SecurityGroupApi securityGroupApi, SecurityGroup securityGroup, int port) {
        this.logger.debug(">> authorizing securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
        securityGroupApi.createRuleAllowingCidrBlock(securityGroup.getId(), ((Ingress.Builder)((Ingress.Builder)((Ingress.Builder)Ingress.builder().ipProtocol(IpProtocol.TCP)).fromPort(port)).toPort(port)).build(), "0.0.0.0/0");
        this.logger.debug("<< authorized securityGroup(%s) permission to 0.0.0.0/0 on port %d", new Object[]{securityGroup, port});
    }
}

