/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.FlavorInZone;

public class FlavorInZoneToHardware
implements Function<FlavorInZone, Hardware> {
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public FlavorInZoneToHardware(Supplier<Map<String, Location>> locationIndex) {
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
    }

    public Hardware apply(FlavorInZone flavorInZone) {
        Location location = (Location)((Map)this.locationIndex.get()).get(flavorInZone.getZone());
        Preconditions.checkState((location != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object[])new Object[]{flavorInZone.getZone(), this.locationIndex.get()});
        Flavor flavor = flavorInZone.getFlavor();
        return new HardwareBuilder().id(flavorInZone.slashEncode()).providerId(flavor.getId()).name(flavor.getName()).ram(flavor.getRam()).processor(new Processor((double)flavor.getVcpus(), 1.0)).volume((Volume)new VolumeImpl(Float.valueOf(flavor.getDisk()), true, true)).location(location).build();
    }
}

