/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.SecurityGroupInZone;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneAndName;
import org.jclouds.openstack.nova.v2_0.domain.zonescoped.ZoneSecurityGroupNameAndPorts;

public class FindSecurityGroupOrCreate
extends CacheLoader<ZoneAndName, SecurityGroupInZone> {
    protected final Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone;
    protected final Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(@Named(value="jclouds.openstack-nova.timeout.securitygroup-present") Predicate<AtomicReference<ZoneAndName>> returnSecurityGroupExistsInZone, Function<ZoneSecurityGroupNameAndPorts, SecurityGroupInZone> groupCreator) {
        this.returnSecurityGroupExistsInZone = (Predicate)Preconditions.checkNotNull(returnSecurityGroupExistsInZone, (Object)"returnSecurityGroupExistsInZone");
        this.groupCreator = (Function)Preconditions.checkNotNull(groupCreator, (Object)"groupCreator");
    }

    public SecurityGroupInZone load(ZoneAndName in) {
        AtomicReference securityGroupInZoneRef = Atomics.newReference((Object)Preconditions.checkNotNull((Object)in, (Object)"zoneSecurityGroupNameAndPorts"));
        if (this.returnSecurityGroupExistsInZone.apply((Object)securityGroupInZoneRef)) {
            return this.returnExistingSecurityGroup(securityGroupInZoneRef);
        }
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroupInZone returnExistingSecurityGroup(AtomicReference<ZoneAndName> securityGroupInZoneRef) {
        ZoneAndName securityGroupInZone = securityGroupInZoneRef.get();
        Preconditions.checkState((boolean)(securityGroupInZone instanceof SecurityGroupInZone), (String)"programming error: predicate %s should update the atomic reference to the actual security group found", (Object[])new Object[]{this.returnSecurityGroupExistsInZone});
        return (SecurityGroupInZone)SecurityGroupInZone.class.cast(securityGroupInZone);
    }

    private SecurityGroupInZone createNewSecurityGroup(ZoneAndName in) {
        Preconditions.checkState((boolean)(Preconditions.checkNotNull((Object)in, (Object)"zoneSecurityGroupNameAndPorts") instanceof ZoneSecurityGroupNameAndPorts), (String)"programming error: when issuing get to this cacheloader, you need to pass an instance of ZoneSecurityGroupNameAndPorts, not %s", (Object[])new Object[]{in});
        ZoneSecurityGroupNameAndPorts zoneSecurityGroupNameAndPorts = (ZoneSecurityGroupNameAndPorts)ZoneSecurityGroupNameAndPorts.class.cast(in);
        return (SecurityGroupInZone)this.groupCreator.apply((Object)zoneSecurityGroupNameAndPorts);
    }

    public String toString() {
        return "returnExistingSecurityGroupInZoneOrCreateAsNeeded()";
    }
}

