/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseFlavorDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseFlavors;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={AuthenticateRequest.class})
public interface FlavorAsyncApi {
    @Named(value="flavor:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavors.class)
    @Transform(value=ParseFlavors.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Resource>> list();

    @Named(value="flavor:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavors.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Resource>> list(PaginationOptions var1);

    @Named(value="flavor:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavorDetails.class)
    @Transform(value=ParseFlavorDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Flavor>> listInDetail();

    @Named(value="flavor:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/flavors/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseFlavorDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Flavor>> listInDetail(PaginationOptions var1);

    @Named(value="flavor:get")
    @GET
    @SelectJson(value={"flavor"})
    @Consumes(value={"application/json"})
    @Path(value="/flavors/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Flavor> get(@PathParam(value="id") String var1);

    @Named(value="flavor:create")
    @POST
    @Unwrap
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/flavors")
    public ListenableFuture<? extends Flavor> create(@WrapWith(value="flavor") Flavor var1);

    @Named(value="flavor:delete")
    @DELETE
    @Consumes
    @Path(value="/flavors/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> delete(@PathParam(value="id") String var1);
}

