/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.binders;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public class UpdateDomainsToJSON
implements MapBinder {
    private static final String template = "{\"domains\":[%s]}";

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        String key;
        String updateTemplate;
        Iterable ids = (Iterable)Iterable.class.cast(postParams.get("ids"));
        if (postParams.get("emailAddress") != null) {
            updateTemplate = "{\"id\":%s,\"%s\":\"%s\"}";
            key = "emailAddress";
        } else if (postParams.get("ttl") != null) {
            updateTemplate = "{\"id\":%s,\"%s\":%s}";
            key = "ttl";
        } else {
            throw new IllegalStateException("emailAddress or ttl not found in " + postParams);
        }
        String value = postParams.get(key).toString();
        return (R)((HttpRequest.Builder)request.toBuilder().payload(this.toJSON(ids, updateTemplate, key, value))).build();
    }

    private String toJSON(Iterable<Integer> ids, String updateTemplate, String key, String value) {
        ArrayList json = Lists.newArrayList();
        for (Integer id : ids) {
            json.add(String.format(updateTemplate, id, key, value));
        }
        String contentsAsOneString = Joiner.on((String)",").join((Iterable)json);
        return String.format(template, contentsAsOneString);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("use map form");
    }
}

