/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.jclouds.javax.annotation.Nullable;

public class Record {
    private final String name;
    private final String type;
    private final Optional<Integer> ttl;
    private final String data;
    private final Integer priority;
    private final String comment;

    private Record(@Nullable String name, @Nullable String type, Optional<Integer> ttl, @Nullable String data, @Nullable Integer priority, @Nullable String comment) {
        this.name = name;
        this.type = type;
        this.ttl = ttl;
        this.data = data;
        this.priority = priority;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public String getData() {
        return this.data;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.ttl, this.data, this.priority, this.comment});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Record that = (Record)Record.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.ttl, that.ttl) && Objects.equal((Object)this.data, (Object)that.data) && Objects.equal((Object)this.priority, (Object)that.priority) && Objects.equal((Object)this.comment, (Object)that.comment);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("ttl", this.ttl).add("data", (Object)this.data).add("priority", (Object)this.priority).add("comment", (Object)this.comment);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Record.builder().from(this);
    }

    public static final class Builder {
        private String name;
        private String type;
        private Optional<Integer> ttl = Optional.absent();
        private String data;
        private Integer priority;
        private String comment;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = Optional.fromNullable((Object)ttl);
            return this;
        }

        public Builder ttl(Optional<Integer> ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Record build() {
            return new Record(this.name, this.type, this.ttl, this.data, this.priority, this.comment);
        }

        public Builder from(Record in) {
            return this.name(in.getName()).type(in.getType()).ttl(in.getTTL()).data(in.getData()).priority(in.getPriority()).comment(in.getComment());
        }
    }
}

