/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.features;

import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rackspace.clouddns.v1.binders.UpdateRecordsToJSON;
import org.jclouds.rackspace.clouddns.v1.config.CloudDNS;
import org.jclouds.rackspace.clouddns.v1.domain.Job;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.functions.ParseJob;
import org.jclouds.rackspace.clouddns.v1.functions.ParseOnlyRecord;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecord;
import org.jclouds.rackspace.clouddns.v1.functions.ParseRecords;
import org.jclouds.rackspace.clouddns.v1.functions.RecordsToPagedIterable;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityFallbacks;
import org.jclouds.rackspace.cloudidentity.v2_0.domain.PaginatedCollection;
import org.jclouds.rackspace.cloudidentity.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindToJsonPayload;

@Endpoint(value=CloudDNS.class)
@RequestFilters(value={AuthenticateRequest.class})
public interface RecordApi {
    @Named(value="record:create")
    @POST
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/records")
    public Job<Set<RecordDetail>> create(@WrapWith(value="records") Iterable<Record> var1);

    @Named(value="record:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecords.class)
    @Transform(value=RecordsToPagedIterable.class)
    @Path(value="/records")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<RecordDetail> list();

    @Named(value="record:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecords.class)
    @Transform(value=RecordsToPagedIterable.class)
    @Path(value="/records")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<RecordDetail> listByType(@QueryParam(value="type") String var1);

    @Named(value="record:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecords.class)
    @Transform(value=RecordsToPagedIterable.class)
    @Path(value="/records")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<RecordDetail> listByTypeAndData(@QueryParam(value="type") String var1, @QueryParam(value="data") String var2);

    @Named(value="record:list")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseRecords.class)
    @Transform(value=RecordsToPagedIterable.class)
    @Path(value="/records")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<RecordDetail> listByNameAndType(@QueryParam(value="name") String var1, @QueryParam(value="type") String var2);

    @Named(value="record:list")
    @GET
    @ResponseParser(value=ParseRecords.class)
    @Consumes(value={"application/json"})
    @Fallback(value=CloudIdentityFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/records")
    public PaginatedCollection<RecordDetail> list(PaginationOptions var1);

    @Named(value="record:get")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseOnlyRecord.class)
    @Path(value="/records")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public RecordDetail getByNameAndTypeAndData(@QueryParam(value="name") String var1, @QueryParam(value="type") String var2, @QueryParam(value="data") String var3);

    @Named(value="record:get")
    @GET
    @ResponseParser(value=ParseRecord.class)
    @Consumes(value={"application/json"})
    @Path(value="/records/{recordId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public RecordDetail get(@PathParam(value="recordId") String var1);

    @Named(value="record:update")
    @PUT
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/records/{recordId}")
    public Job<Void> update(@PathParam(value="recordId") String var1, @BinderParam(value=BindToJsonPayload.class) Record var2);

    @Named(value="record:update")
    @PUT
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseJob.class)
    @Path(value="/records")
    public Job<Void> update(@BinderParam(value=UpdateRecordsToJSON.class) Map<String, Record> var1);

    @Named(value="record:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @ResponseParser(value=ParseJob.class)
    @Path(value="/records/{recordId}")
    @Consumes(value={"*/*"})
    public Job<Void> delete(@PathParam(value="recordId") String var1);

    @Named(value="record:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @ResponseParser(value=ParseJob.class)
    @Path(value="/records")
    @Consumes(value={"*/*"})
    public Job<Void> delete(@QueryParam(value="id") Iterable<String> var1);
}

