/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class PaginationOptions
extends BaseHttpRequestOptions {
    public PaginationOptions queryParameters(Multimap<String, String> queryParams) {
        Preconditions.checkNotNull(queryParams, (Object)"queryParams");
        this.queryParameters.putAll(queryParams);
        return this;
    }

    public PaginationOptions offset(int offset) {
        Preconditions.checkState((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
        this.queryParameters.put((Object)"offset", (Object)String.valueOf(offset));
        return this;
    }

    public PaginationOptions limit(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public PaginationOptions name(String nameFilter) {
        this.queryParameters.put((Object)"name", (Object)nameFilter);
        return this;
    }

    public static class Builder {
        public static PaginationOptions queryParameters(Multimap<String, String> queryParams) {
            PaginationOptions options = new PaginationOptions();
            return options.queryParameters(queryParams);
        }

        public static PaginationOptions offset(int offset) {
            PaginationOptions options = new PaginationOptions();
            return options.offset(offset);
        }

        public static PaginationOptions limit(int limit) {
            PaginationOptions options = new PaginationOptions();
            return options.limit(limit);
        }

        public static PaginationOptions name(String name) {
            PaginationOptions options = new PaginationOptions();
            return options.name(name);
        }
    }
}

