/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRule;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRuleWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.AccessRuleApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AccessRuleApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testListAccessRules() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/accesslist");
        AccessRuleApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/accesslist-list.json"))).build())).getAccessRuleApiForZoneAndLoadBalancer("DFW", 2000);
        Iterable accessList = api.list();
        Assert.assertEquals((Object)accessList, this.getAccessRules());
    }

    public void testCreateAccessRules() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/accesslist");
        AccessRuleApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").endpoint(endpoint).payload(this.payloadFromResource("/accesslist-create.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getAccessRuleApiForZoneAndLoadBalancer("DFW", 2000);
        AccessRule accessRule1 = AccessRule.deny((String)"206.160.163.21");
        AccessRule accessRule2 = AccessRule.deny((String)"206.160.165.11");
        AccessRule accessRule3 = AccessRule.deny((String)"206.160.163.22");
        ImmutableList accessList = ImmutableList.of((Object)accessRule1, (Object)accessRule2, (Object)accessRule3);
        api.create((Iterable)accessList);
    }

    public void testRemoveSingleAccessRule() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/accesslist/23");
        AccessRuleApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getAccessRuleApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.delete(23));
    }

    public void testRemoveManyAccessRules() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/accesslist?id=23&id=24");
        AccessRuleApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getAccessRuleApiForZoneAndLoadBalancer("DFW", 2000);
        ImmutableList accessRuleIds = ImmutableList.of((Object)23, (Object)24);
        Assert.assertTrue((boolean)api.delete((Iterable)accessRuleIds));
    }

    public void testRemoveAllAccessRules() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/accesslist");
        AccessRuleApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getAccessRuleApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.deleteAll());
    }

    private Iterable<AccessRuleWithId> getAccessRules() {
        AccessRuleWithId accessRule1 = new AccessRuleWithId(23, "206.160.163.21", AccessRule.Type.DENY);
        AccessRuleWithId accessRule2 = new AccessRuleWithId(24, "206.160.165.11", AccessRule.Type.DENY);
        AccessRuleWithId accessRule3 = new AccessRuleWithId(25, "206.160.163.22", AccessRule.Type.DENY);
        return ImmutableList.of((Object)accessRule1, (Object)accessRule2, (Object)accessRule3);
    }
}

