/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRule;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRuleWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AccessListApiLiveTest")
public class AccessRuleApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private LoadBalancer lb;
    private String zone;
    private AccessRule accessRule1;
    private AccessRule accessRule2;
    private AccessRule accessRule3;
    private AccessRule accessRule4;
    private Map<String, AccessRule> accessRules;

    @Override
    @BeforeGroups(groups={"live"})
    public void setup() {
        super.setup();
        this.accessRule1 = AccessRule.deny((String)"206.160.163.21");
        this.accessRule2 = AccessRule.deny((String)"206.160.165.11");
        this.accessRule3 = AccessRule.deny((String)"206.160.163.22");
        this.accessRule4 = AccessRule.deny((String)"206.160.168.22");
        this.accessRules = new HashMap<String, AccessRule>();
        this.accessRules.put(this.accessRule1.getAddress(), this.accessRule1);
        this.accessRules.put(this.accessRule2.getAddress(), this.accessRule2);
        this.accessRules.put(this.accessRule3.getAddress(), this.accessRule3);
        this.accessRules.put(this.accessRule4.getAddress(), this.accessRule4);
    }

    public void testCreateLoadBalancer() {
        AddNode addNode = AddNode.builder().address("192.168.1.1").port(8080).build();
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name(this.prefix + "-jclouds").protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(addNode).build();
        this.zone = "ORD";
        this.lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).create(createLB);
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testCreateAccessList() throws Exception {
        ((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).create(this.accessRules.values());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        this.assertExpectedAccessRules(this.accessRules);
    }

    @Test(dependsOnMethods={"testCreateAccessList"})
    public void testRemoveSingleAccessRule() throws Exception {
        Iterable actualAccessList = ((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        AccessRuleWithId removedAccessRule = (AccessRuleWithId)Iterables.getFirst((Iterable)actualAccessList, null);
        this.accessRules.remove(removedAccessRule.getAddress());
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).delete(removedAccessRule.getId()));
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        this.assertExpectedAccessRules(this.accessRules);
    }

    @Test(dependsOnMethods={"testRemoveSingleAccessRule"})
    public void testRemoveManyAccessRules() throws Exception {
        Iterable actualAccessList = ((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        AccessRuleWithId removedAccessRule1 = (AccessRuleWithId)Iterables.getFirst((Iterable)actualAccessList, null);
        AccessRuleWithId removedAccessRule2 = (AccessRuleWithId)Iterables.getLast((Iterable)actualAccessList);
        ImmutableList removedAccessRuleIds = ImmutableList.of((Object)removedAccessRule1.getId(), (Object)removedAccessRule2.getId());
        this.accessRules.remove(removedAccessRule1.getAddress());
        this.accessRules.remove(removedAccessRule2.getAddress());
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).delete((Iterable)removedAccessRuleIds));
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        this.assertExpectedAccessRules(this.accessRules);
    }

    @Test(dependsOnMethods={"testRemoveManyAccessRules"})
    public void testRemoveAllAccessRules() throws Exception {
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).deleteAll());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        this.assertExpectedAccessRules(new HashMap<String, AccessRule>());
    }

    private void assertExpectedAccessRules(Map<String, AccessRule> expectedAccessList) {
        Iterable actualAccessList = ((CloudLoadBalancersApi)this.api).getAccessRuleApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        for (AccessRule actualAccessRule : actualAccessList) {
            Assert.assertEquals((boolean)expectedAccessList.containsKey(actualAccessRule.getAddress()), (boolean)true, (String)("The AccessRule " + actualAccessRule + " was not found in " + expectedAccessList));
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).delete(this.lb.getId());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        super.tearDown();
    }
}

