/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ConnectionApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ConnectionApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testGetConnectionThrottle() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionthrottle");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/connectionthrottle-get.json"))).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        ConnectionThrottle connectionThrottle = api.getConnectionThrottle();
        Assert.assertEquals((Object)connectionThrottle, (Object)ConnectionApiExpectTest.getConnectionThrottle());
    }

    public void testGetDeletedConnectionThrottle() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionthrottle");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/connectionthrottle-get-deleted.json"))).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        ConnectionThrottle connectionThrottle = api.getConnectionThrottle();
        Assert.assertNull((Object)connectionThrottle);
    }

    public void testCreateConnectionThrottle() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionthrottle");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/connectionthrottle-create.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        api.createOrUpdateConnectionThrottle(ConnectionApiExpectTest.getConnectionThrottle());
    }

    public void testValidConnectionThrottle() {
        Assert.assertTrue((boolean)ConnectionApiExpectTest.getConnectionThrottle().isValid());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidConnectionThrottle() {
        ConnectionThrottle.builder().build();
    }

    public void testRemoveConnectionThrottle() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionthrottle");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.deleteConnectionThrottle());
    }

    public void testIsConnectionLogging() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionlogging");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/connectionlogging-enable.json"))).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.isConnectionLogging());
    }

    public void testEnableConnectionLogging() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionlogging");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/connectionlogging-enable.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        api.enableConnectionLogging();
    }

    public void testDisableConnectionLogging() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/connectionlogging");
        ConnectionApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/connectionlogging-disable.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getConnectionApiForZoneAndLoadBalancer("DFW", 2000);
        api.disableConnectionLogging();
    }

    public static ConnectionThrottle getConnectionThrottle() {
        ConnectionThrottle connectionThrottle = ConnectionThrottle.builder().maxConnections(100).maxConnectionRate(100).minConnections(10).rateInterval(100).build();
        return connectionThrottle;
    }
}

