/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.Iterables;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ConnectionApiExpectTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ConnectionApiLiveTest")
public class ConnectionApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private LoadBalancer lb;
    private String zone;

    public void testCreateLoadBalancer() {
        AddNode addNode = AddNode.builder().address("192.168.1.1").port(8080).build();
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name(this.prefix + "-jclouds").protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(addNode).build();
        this.zone = (String)Iterables.getFirst((Iterable)((CloudLoadBalancersApi)this.api).getConfiguredZones(), null);
        this.lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).create(createLB);
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testCreateAndGetConnectionThrottling() throws Exception {
        ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).createOrUpdateConnectionThrottle(ConnectionApiExpectTest.getConnectionThrottle());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ConnectionThrottle connectionThrottle = ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).getConnectionThrottle();
        Assert.assertEquals((Object)connectionThrottle, (Object)ConnectionApiExpectTest.getConnectionThrottle());
    }

    @Test(dependsOnMethods={"testCreateAndGetConnectionThrottling"})
    public void testRemoveAndGetConnectionThrottle() throws Exception {
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).deleteConnectionThrottle());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ConnectionThrottle connectionThrottle = ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).getConnectionThrottle();
        Assert.assertNull((Object)connectionThrottle);
    }

    @Test(dependsOnMethods={"testRemoveAndGetConnectionThrottle"})
    public void testEnableAndIsConnectionLogging() throws Exception {
        ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).enableConnectionLogging();
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        boolean isConnectionLogging = ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).isConnectionLogging();
        Assert.assertTrue((boolean)isConnectionLogging);
    }

    @Test(dependsOnMethods={"testEnableAndIsConnectionLogging"})
    public void testDisableAndIsConnectionLogging() throws Exception {
        ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).disableConnectionLogging();
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        boolean isConnectionLogging = ((CloudLoadBalancersApi)this.api).getConnectionApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).isConnectionLogging();
        Assert.assertFalse((boolean)isConnectionLogging);
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).delete(this.lb.getId());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        super.tearDown();
    }
}

