/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ContentCachingApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ContentCachingApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testIsContentCaching() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/contentcaching");
        ContentCachingApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/contentcaching-enable.json"))).build())).getContentCachingApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.isContentCaching());
    }

    public void testEnableContentCaching() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/contentcaching");
        ContentCachingApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/contentcaching-enable.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getContentCachingApiForZoneAndLoadBalancer("DFW", 2000);
        api.enable();
    }

    public void testDisableContentCaching() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/contentcaching");
        ContentCachingApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/contentcaching-disable.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getContentCachingApiForZoneAndLoadBalancer("DFW", 2000);
        api.disable();
    }
}

