/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.Iterables;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ContentCachingApiLiveTest")
public class ContentCachingApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private LoadBalancer lb;
    private String zone;

    public void testCreateLoadBalancer() {
        AddNode addNode = AddNode.builder().address("192.168.1.1").port(8080).build();
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name(this.prefix + "-jclouds").protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(addNode).build();
        this.zone = (String)Iterables.getFirst((Iterable)((CloudLoadBalancersApi)this.api).getConfiguredZones(), null);
        this.lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).create(createLB);
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testEnableAndIsContentCaching() throws Exception {
        ((CloudLoadBalancersApi)this.api).getContentCachingApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).enable();
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        boolean isContentCaching = ((CloudLoadBalancersApi)this.api).getContentCachingApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).isContentCaching();
        Assert.assertTrue((boolean)isContentCaching);
    }

    @Test(dependsOnMethods={"testEnableAndIsContentCaching"})
    public void testDisableAndIsContentCaching() throws Exception {
        ((CloudLoadBalancersApi)this.api).getContentCachingApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).disable();
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        boolean isContentCaching = ((CloudLoadBalancersApi)this.api).getContentCachingApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).isContentCaching();
        Assert.assertFalse((boolean)isContentCaching);
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).delete(this.lb.getId());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        super.tearDown();
    }
}

