/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancerTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseLoadBalancersTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class LoadBalancerApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testListLoadBalancers() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/loadbalancers-list.json"))).build())).getLoadBalancerApiForZone("DFW");
        ImmutableSet loadBalancers = api.list().concat().toSet();
        Assert.assertEquals((Set)loadBalancers, this.getExpectedLoadBalancers());
    }

    public void testGetLoadBalancer() throws Exception {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/loadbalancer-get.json"))).build())).getLoadBalancerApiForZone("DFW");
        LoadBalancer loadBalancer = api.get(2000);
        Assert.assertEquals((Object)loadBalancer, (Object)this.getExpectedLoadBalancer());
    }

    public void testCreateLoadBalancer() throws Exception {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").payload(this.payloadFromResource("/loadbalancer-create.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/loadbalancer-get.json"))).build())).getLoadBalancerApiForZone("DFW");
        AddNode addNode1 = AddNode.builder().address("10.1.1.1").condition(BaseNode.Condition.ENABLED).port(80).build();
        AddNode addNode2 = AddNode.builder().address("10.1.1.2").condition(BaseNode.Condition.ENABLED).port(80).build();
        HashSet addNodes = Sets.newHashSet((Object[])new AddNode[]{addNode1, addNode2});
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name("sample-loadbalancer").protocol("HTTP").port(Integer.valueOf(80)).algorithm(BaseLoadBalancer.Algorithm.RANDOM).virtualIPType(VirtualIP.Type.PUBLIC).nodes((Iterable)addNodes).build();
        LoadBalancer loadBalancer = api.create(createLB);
        Assert.assertEquals((Object)loadBalancer, (Object)this.getExpectedLoadBalancer());
    }

    public void testUpdateLoadBalancerAttributes() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").payload(this.payloadFromResource("/loadbalancer-update.json"))).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.ACCEPTED.getStatusCode()).payload("")).build())).getLoadBalancerApiForZone("DFW");
        UpdateLoadBalancer updateLB = UpdateLoadBalancer.builder().name("foo").protocol("HTTPS").port(Integer.valueOf(443)).algorithm(BaseLoadBalancer.Algorithm.RANDOM).build();
        api.update(2000, updateLB);
    }

    public void testRemoveLoadBalancer() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").replaceHeader("Accept", new String[]{"*/*"})).endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.ACCEPTED.getStatusCode()).payload("")).build())).getLoadBalancerApiForZone("DFW");
        api.delete(2000);
    }

    public void testListMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/metadata");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/metadata-list.json"))).build())).getLoadBalancerApiForZone("DFW");
        Metadata metadata = api.getMetadata(2000);
        Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadataWithIds());
    }

    public void testCreateMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/metadata");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("POST").endpoint(endpoint).payload(this.payloadFromResourceWithContentType("/metadata-create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/metadata-list.json"))).build())).getLoadBalancerApiForZone("DFW");
        Metadata metadata = api.createMetadata(2000, (Map)this.getExpectedMetadata());
        Assert.assertEquals((Map)metadata, (Map)this.getExpectedMetadataWithIds());
    }

    public void testRemoveSingleMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/metadata/23");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getLoadBalancerApiForZone("DFW");
        Assert.assertTrue((boolean)api.deleteMetadatum(2000, 23));
    }

    public void testRemoveManyMetadata() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/metadata?id=23&id=24");
        LoadBalancerApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getLoadBalancerApiForZone("DFW");
        Assert.assertTrue((boolean)api.deleteMetadata(2000, (Iterable)ImmutableList.of((Object)23, (Object)24)));
    }

    private Object getExpectedLoadBalancer() {
        return new ParseLoadBalancerTest().expected();
    }

    private Set<LoadBalancer> getExpectedLoadBalancers() {
        return new ParseLoadBalancersTest().data();
    }

    private Metadata getExpectedMetadata() {
        Metadata metadata = new Metadata();
        metadata.put((Object)"color", (Object)"red");
        metadata.put((Object)"label", (Object)"web-load-balancer");
        metadata.put((Object)"os", (Object)"ubuntu");
        return metadata;
    }

    private Metadata getExpectedMetadataWithIds() {
        Metadata metadata = this.getExpectedMetadata();
        metadata.putId("color", 1);
        metadata.putId("label", 2);
        metadata.putId("os", 3);
        return metadata;
    }
}

