/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SSLTermination;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SSLTerminationApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SSLTerminationApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testGetSSLTermination() throws IOException {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/ssltermination");
        SSLTerminationApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/ssltermination-get.json"))).build())).getSSLTerminationApiForZoneAndLoadBalancer("DFW", 2000);
        SSLTermination sslTermination = api.get();
        Assert.assertEquals((Object)sslTermination, (Object)SSLTerminationApiExpectTest.getSSLTermination());
    }

    public void testGetDeletedSSLTermination() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/ssltermination");
        SSLTerminationApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(Response.Status.NOT_FOUND.getStatusCode()).build())).getSSLTerminationApiForZoneAndLoadBalancer("DFW", 2000);
        SSLTermination sslTermination = api.get();
        Assert.assertNull((Object)sslTermination);
    }

    public void testCreateSSLTermination() throws IOException {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/ssltermination");
        SSLTerminationApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResourceWithContentType("/ssltermination-create.json", "application/json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getSSLTerminationApiForZoneAndLoadBalancer("DFW", 2000);
        api.createOrUpdate(SSLTerminationApiExpectTest.getSSLTermination());
    }

    public void testRemoveSSLTermination() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/ssltermination");
        SSLTerminationApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("DELETE").endpoint(endpoint).replaceHeader("Accept", new String[]{"*/*"})).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getSSLTerminationApiForZoneAndLoadBalancer("DFW", 2000);
        Assert.assertTrue((boolean)api.delete());
    }

    public static SSLTermination getSSLTermination() throws IOException {
        String certificate = Strings2.toStringAndClose((InputStream)SSLTerminationApiExpectTest.class.getResourceAsStream("/ssltermination-certificate.txt"));
        String privateKey = Strings2.toStringAndClose((InputStream)SSLTerminationApiExpectTest.class.getResourceAsStream("/ssltermination-privatekey.txt"));
        String intermediateCertificate = Strings2.toStringAndClose((InputStream)SSLTerminationApiExpectTest.class.getResourceAsStream("/ssltermination-intermediatecertificate.txt"));
        SSLTermination sslTermination = SSLTermination.builder().enabled(true).secureTrafficOnly(false).securePort(443).certificate(certificate).privatekey(privateKey).intermediateCertificate(intermediateCertificate).build();
        return sslTermination;
    }
}

