/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.SessionPersistenceApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancerApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SessionPersistenceApiExpectTest
extends BaseCloudLoadBalancerApiExpectTest<CloudLoadBalancersApi> {
    public void testGetSessionPersistence() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/sessionpersistence");
        SessionPersistenceApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/sessionpersistence-get.json"))).build())).getSessionPersistenceApiForZoneAndLoadBalancer("DFW", 2000);
        SessionPersistence sessionPersistence = api.get();
        Assert.assertEquals((Object)sessionPersistence, (Object)SessionPersistence.HTTP_COOKIE);
    }

    public void testGetDeletedSessionPersistence() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/sessionpersistence");
        SessionPersistenceApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResource("/sessionpersistence-get-deleted.json"))).build())).getSessionPersistenceApiForZoneAndLoadBalancer("DFW", 2000);
        SessionPersistence sessionPersistence = api.get();
        Assert.assertNull((Object)sessionPersistence);
    }

    public void testCreateSessionPersistence() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/sessionpersistence");
        SessionPersistenceApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, ((HttpRequest.Builder)this.authenticatedGET().method("PUT").endpoint(endpoint).payload(this.payloadFromResource("/sessionpersistence-create.json"))).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getSessionPersistenceApiForZoneAndLoadBalancer("DFW", 2000);
        api.create(SessionPersistence.HTTP_COOKIE);
    }

    public void testRemoveSessionPersistence() {
        URI endpoint = URI.create("https://dfw.loadbalancers.api.rackspacecloud.com/v1.0/123123/loadbalancers/2000/sessionpersistence");
        SessionPersistenceApi api = ((CloudLoadBalancersApi)this.requestsSendResponses(this.rackspaceAuthWithUsernameAndApiKey, this.responseWithAccess, this.authenticatedGET().method("DELETE").endpoint(endpoint).build(), HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).build())).getSessionPersistenceApiForZoneAndLoadBalancer("DFW", 2000);
        api.delete();
    }
}

