/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.CreateLoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.internal.BaseCloudLoadBalancersApiLiveTest;
import org.jclouds.rackspace.cloudloadbalancers.v1.predicates.LoadBalancerPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="VirtualIPApiLiveTest")
public class VirtualIPApiLiveTest
extends BaseCloudLoadBalancersApiLiveTest {
    private LoadBalancer lb;
    private String zone;

    public void testCreateLoadBalancer() {
        AddNode addNode = AddNode.builder().address("192.168.1.1").port(8080).build();
        CreateLoadBalancer createLB = CreateLoadBalancer.builder().name(this.prefix + "-jclouds").protocol("HTTP").port(Integer.valueOf(80)).virtualIPType(VirtualIP.Type.PUBLIC).node(addNode).build();
        this.zone = (String)Iterables.getFirst((Iterable)((CloudLoadBalancersApi)this.api).getConfiguredZones(), null);
        this.lb = ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).create(createLB);
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
    }

    @Test(dependsOnMethods={"testCreateLoadBalancer"})
    public void testCreateVirtualIPs() throws Exception {
        ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).create(VirtualIP.publicIPv6());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).create(VirtualIP.publicIPv6());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).create(VirtualIP.publicIPv6());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        Iterable actualVirtualIPs = ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        Assert.assertEquals((int)Iterators.size(actualVirtualIPs.iterator()), (int)5);
    }

    @Test(dependsOnMethods={"testCreateVirtualIPs"})
    public void testRemoveSingleVirtualIP() throws Exception {
        Iterable actualVirtualIPs = ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        VirtualIPWithId removedVirtualIP = (VirtualIPWithId)Iterables.getFirst((Iterable)actualVirtualIPs, null);
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).delete(removedVirtualIP.getId()));
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        actualVirtualIPs = ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        Assert.assertEquals((int)Iterators.size(actualVirtualIPs.iterator()), (int)4);
    }

    @Test(dependsOnMethods={"testRemoveSingleVirtualIP"})
    public void testRemoveManyVirtualIPs() throws Exception {
        Iterable actualVirtualIPs = ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        VirtualIPWithId removedVirtualIP1 = (VirtualIPWithId)Iterables.getFirst((Iterable)actualVirtualIPs, null);
        VirtualIPWithId removedVirtualIP2 = (VirtualIPWithId)Iterables.getLast((Iterable)actualVirtualIPs);
        ImmutableList removedVirtualIPIds = ImmutableList.of((Object)removedVirtualIP1.getId(), (Object)removedVirtualIP2.getId());
        Assert.assertTrue((boolean)((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).delete((Iterable)removedVirtualIPIds));
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        actualVirtualIPs = ((CloudLoadBalancersApi)this.api).getVirtualIPApiForZoneAndLoadBalancer(this.zone, this.lb.getId()).list();
        Assert.assertEquals((int)Iterators.size(actualVirtualIPs.iterator()), (int)2);
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitAvailable((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        ((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone).delete(this.lb.getId());
        Assert.assertTrue((boolean)LoadBalancerPredicates.awaitDeleted((LoadBalancerApi)((CloudLoadBalancersApi)this.api).getLoadBalancerApiForZone(this.zone)).apply((Object)this.lb));
        super.tearDown();
    }
}

