/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class VirtualIP {
    private final Type type;
    private final IPVersion ipVersion;

    public static VirtualIP publicIPv6() {
        return new VirtualIP(Type.PUBLIC, IPVersion.IPV6);
    }

    protected VirtualIP(Type type, IPVersion ipVersion) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.ipVersion = (IPVersion)((Object)Preconditions.checkNotNull((Object)((Object)ipVersion), (Object)"ipVersion"));
    }

    public Type getType() {
        return this.type;
    }

    public IPVersion getIpVersion() {
        return this.ipVersion;
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("ipVersion", (Object)this.ipVersion).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ipVersion, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualIP that = (VirtualIP)VirtualIP.class.cast(obj);
        return Objects.equal((Object)((Object)this.ipVersion), (Object)((Object)that.ipVersion)) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
    }

    public static enum IPVersion {
        IPV4,
        IPV6,
        UNRECOGNIZED;


        public static IPVersion fromValue(String ipVersion) {
            try {
                return IPVersion.valueOf((String)Preconditions.checkNotNull((Object)ipVersion, (Object)"ipVersion"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        PUBLIC,
        SERVICENET,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

