/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Date;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.logging.Logger;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRuleWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIPWithId;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.LB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseMetadata;

public class ConvertLB
implements Function<LB, LoadBalancer> {
    private static final String LOAD_BALANCERS = "loadbalancers";
    @Resource
    protected Logger logger = Logger.NULL;
    private final String region;
    private final URI endpoint;

    @Inject
    ConvertLB(@Assisted URI endpoint, @Assisted String region) {
        this.endpoint = endpoint;
        this.region = region.toUpperCase();
    }

    public LoadBalancer apply(LB lb) {
        try {
            LoadBalancer.Builder builder = ((LoadBalancer.Builder)LoadBalancer.builder().id(lb.id).region(this.region).status(lb.status).name(lb.getName()).protocol(lb.getProtocol()).port(lb.getPort()).nodeCount(lb.nodeCount).nodes((Iterable)lb.getNodes())).timeout(lb.getTimeout()).algorithm(lb.getAlgorithm()).halfClosed(lb.isHalfClosed()).sessionPersistenceType(lb.getSessionPersistenceType()).connectionLogging(lb.isConnectionLogging()).connectionThrottle(lb.getConnectionThrottle()).healthMonitor(lb.getHealthMonitor());
            if (lb.cluster.size() == 1) {
                builder.clusterName((String)Iterables.get(lb.cluster.values(), (int)0));
            }
            if (lb.created.size() == 1) {
                builder.created((Date)Iterables.get(lb.created.values(), (int)0));
            }
            if (lb.updated.size() == 1) {
                builder.updated((Date)Iterables.get(lb.updated.values(), (int)0));
            }
            if (lb.contentCaching.size() == 1) {
                builder.contentCaching((Boolean)Iterables.get(lb.contentCaching.values(), (int)0));
            }
            if (lb.sslTermination != null) {
                builder.sslTermination(lb.sslTermination);
            }
            if (lb.sourceAddresses != null) {
                builder.sourceAddresses(lb.sourceAddresses);
            }
            if (lb.accessList == null) {
                builder.accessRules((Iterable<AccessRuleWithId>)ImmutableSet.of());
            } else {
                builder.accessRules(lb.accessList);
            }
            if (lb.virtualIps == null) {
                builder.virtualIPs((Iterable<VirtualIPWithId>)ImmutableSet.of());
            } else {
                builder.virtualIPs(lb.virtualIps);
            }
            if (lb.metadata == null) {
                builder.metadata(new Metadata());
            } else {
                builder.metadata(ParseMetadata.transformCLBMetadataToMetadata(lb.metadata));
            }
            int indexOfLB = this.endpoint.toString().lastIndexOf(LOAD_BALANCERS);
            String path = this.endpoint.toString().substring(0, indexOfLB + LOAD_BALANCERS.length());
            builder.uri(URI.create(path + "/" + lb.id));
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.warn((Throwable)e, "nullpointer found parsing %s", new Object[]{lb});
            throw e;
        }
    }

    public static interface Factory {
        public ConvertLB createForEndpointAndRegion(URI var1, String var2);
    }
}

