/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.NodeApi;

@Singleton
@Beta
public class ParseNodes
extends ParseJson<Nodes> {
    @Inject
    public ParseNodes(Json json) {
        super(json, (TypeLiteral)new TypeLiteral<Nodes>(){});
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Node, ToPagedIterable> {
        private final CloudLoadBalancersApi api;
        private int lbId;

        @Inject
        protected ToPagedIterable(CloudLoadBalancersApi api) {
            this.api = (CloudLoadBalancersApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        public ToPagedIterable setContext(HttpRequest request) {
            String path = request.getEndpoint().getPath();
            int lastSlash = path.lastIndexOf(47);
            int secondLastSlash = path.lastIndexOf(47, lastSlash - 1);
            this.lbId = Integer.valueOf(path.substring(secondLastSlash + 1, lastSlash));
            return (ToPagedIterable)super.setContext(request);
        }

        protected Function<Object, IterableWithMarker<Node>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.isPresent() ? arg0.get().toString() : null;
            final NodeApi nodeApi = this.api.getNodeApiForZoneAndLoadBalancer(zone, this.lbId);
            return new Function<Object, IterableWithMarker<Node>>(){

                public IterableWithMarker<Node> apply(Object input) {
                    IterableWithMarker<Node> list = nodeApi.list(PaginationOptions.Builder.marker((String)input.toString()));
                    return list;
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class Nodes
    extends PaginatedCollection<Node> {
        @ConstructorProperties(value={"nodes", "nodes_links"})
        protected Nodes(Iterable<Node> nodes, Iterable<Link> nodes_links) {
            super(nodes, nodes_links);
        }
    }
}

