/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class S3ClientMockTest {
    private static final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));

    static S3Client getS3Client(URL server) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.s3.virtual-host-buckets", "false");
        overrides.setProperty("jclouds.so-timeout", "0");
        overrides.setProperty("jclouds.max-retries", "1");
        return (S3Client)ContextBuilder.newBuilder((String)"s3").credentials("accessKey", "secretKey").endpoint(server.toString()).modules(modules).overrides(overrides).buildApi(S3Client.class);
    }

    public void testZeroLengthPutHasContentLengthHeader() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().addHeader("ETag", (Object)"ABCDEF"));
        server.enqueue(new MockResponse().addHeader("ETag", (Object)"ABCDEF"));
        server.play();
        S3Client client = S3ClientMockTest.getS3Client(server.getUrl("/"));
        S3Object nada = client.newS3Object();
        nada.getMetadata().setKey("object");
        nada.setPayload(new byte[0]);
        Assert.assertEquals((String)client.putObject("bucket", nada, new PutObjectOptions[0]), (String)"ABCDEF");
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((String)request.getRequestLine(), (String)"PUT /bucket/object HTTP/1.1");
        Assert.assertEquals((Collection)request.getHeaders("Content-Length"), (Collection)ImmutableList.of((Object)"0"));
        Assert.assertEquals((Collection)request.getHeaders("Expect"), (Collection)ImmutableList.of((Object)"100-continue"));
        server.shutdown();
    }

    public void testDirectorySeparator() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("").addHeader("ETag", (Object)"ABCDEF"));
        server.play();
        S3Client client = S3ClientMockTest.getS3Client(server.getUrl("/"));
        S3Object fileInDir = client.newS3Object();
        fileInDir.getMetadata().setKey("someDir/fileName");
        fileInDir.setPayload(new byte[]{1, 2, 3, 4});
        Assert.assertEquals((String)client.putObject("bucket", fileInDir, new PutObjectOptions[0]), (String)"ABCDEF");
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((String)request.getRequestLine(), (String)"PUT /bucket/someDir/fileName HTTP/1.1");
        Assert.assertEquals((Collection)request.getHeaders("Expect"), (Collection)ImmutableList.of((Object)"100-continue"));
        server.shutdown();
    }
}

