/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.handlers;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.rest.RequestSigner;
import org.jclouds.s3.handlers.ParseS3ErrorFromXmlContent;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseS3ErrorFromXmlContentTest {
    private static final String SERVICE_PATH = "/services/Walrus";

    @Test
    public void test404ContainerNotFoundExceptionPath() {
        this.assertCodeMakes("GET", URI.create("http://partnercloud.eucalyptus.com:8773/services/Walrus/adriancole-blobstore58/"), 404, "HTTP/1.1 404 Not Found", false, "<Error><Code>Monster.NotFound</Code></Error>", ContainerNotFoundException.class);
    }

    @Test
    public void test404KeyNotFoundExceptionPath() {
        this.assertCodeMakes("GET", URI.create("http://partnercloud.eucalyptus.com:8773/services/Walrus/adriancole-blobstore58/apples"), 404, "HTTP/1.1 404 Not Found", false, "<Error><Code>Monster.NotFound</Code></Error>", KeyNotFoundException.class);
    }

    private void assertCodeMakes(String method, URI uri, int statusCode, String message, final boolean virtualHost, String content, Class<? extends Exception> expected) {
        ParseS3ErrorFromXmlContent function = (ParseS3ErrorFromXmlContent)Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind(RequestSigner.class).toInstance(EasyMock.createMock(RequestSigner.class));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.aws.header.tag")).to("amz");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.s3.service-path")).to(ParseS3ErrorFromXmlContentTest.SERVICE_PATH);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.s3.virtual-host-buckets")).to(virtualHost);
            }
        }}).getInstance(ParseS3ErrorFromXmlContent.class);
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        HttpRequest request = HttpRequest.builder().method(method).endpoint(uri).build();
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(statusCode).message(message).payload(content)).build();
        response.getPayload().getContentMetadata().setContentType("application/xml");
        EasyMock.expect((Object)command.getCurrentRequest()).andReturn((Object)request).atLeastOnce();
        command.setException(ParseS3ErrorFromXmlContentTest.classEq(expected));
        EasyMock.replay((Object[])new Object[]{command});
        function.handleError(command, response);
        EasyMock.verify((Object[])new Object[]{command});
    }

    public static Exception classEq(final Class<? extends Exception> in) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){

            public void appendTo(StringBuffer buffer) {
                buffer.append("classEq(");
                buffer.append(in);
                buffer.append(")");
            }

            public boolean matches(Object arg) {
                return arg.getClass() == in;
            }
        });
        return null;
    }
}

