/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.collect.Multimap;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.options.PutBucketOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PutBucketOptionsTest {
    @Test
    public void testAclDefault() {
        PutBucketOptions options = new PutBucketOptions();
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.PRIVATE);
    }

    @Test
    public void testAclStatic() {
        PutBucketOptions options = PutBucketOptions.Builder.withBucketAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.AUTHENTICATED_READ);
    }

    @Test
    void testBuildRequestHeaders() {
        PutBucketOptions options = PutBucketOptions.Builder.withBucketAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        options.setHeaderTag("amz");
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((String)((String)headers.get((Object)"x-amz-acl").iterator().next()), (String)CannedAccessPolicy.AUTHENTICATED_READ.toString());
    }
}

