/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.collect.Multimap;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class PutObjectOptionsTest {
    @Test
    public void testAclDefault() {
        PutObjectOptions options = new PutObjectOptions();
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.PRIVATE);
    }

    @Test
    public void testAclStatic() {
        PutObjectOptions options = PutObjectOptions.Builder.withAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.AUTHENTICATED_READ);
    }

    @Test
    void testBuildRequestHeaders() {
        PutObjectOptions options = PutObjectOptions.Builder.withAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        options.setHeaderTag("amz");
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((String)((String)headers.get((Object)"x-amz-acl").iterator().next()), (String)CannedAccessPolicy.AUTHENTICATED_READ.toString());
    }
}

