/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import org.jclouds.http.HttpException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.xml.AccessControlListHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AccessControlListHandlerTest")
public class AccessControlListHandlerTest
extends BaseHandlerTest {
    public static final String aclOwnerOnly = "<AccessControlPolicy xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Owner><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Owner><AccessControlList><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Grantee><Permission>FULL_CONTROL</Permission></Grant></AccessControlList></AccessControlPolicy>";
    public static final String aclExtreme = "<AccessControlPolicy xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Owner><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Owner><AccessControlList><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/global/AuthenticatedUsers</URI></Grantee><Permission>WRITE</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/global/AuthenticatedUsers</URI></Grantee><Permission>READ_ACP</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Grantee><Permission>WRITE</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/global/AuthenticatedUsers</URI></Grantee><Permission>WRITE_ACP</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/global/AllUsers</URI></Grantee><Permission>READ</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/global/AuthenticatedUsers</URI></Grantee><Permission>READ</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\"><URI>http://acs.amazonaws.com/groups/s3/LogDelivery</URI></Grantee><Permission>WRITE</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Grantee><Permission>READ</Permission></Grant><Grant><Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"CanonicalUser\"><ID>1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c</ID><DisplayName>jamesmurty</DisplayName></Grantee><Permission>FULL_CONTROL</Permission></Grant></AccessControlList></AccessControlPolicy>";

    ParseSax<AccessControlList> createParser() {
        ParseSax parser = this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(AccessControlListHandler.class));
        return parser;
    }

    @Test
    public void testAccessControlListOwnerOnly() throws HttpException {
        String ownerId = "1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c";
        AccessControlList acl = (AccessControlList)this.createParser().parse(Strings2.toInputStream((String)aclOwnerOnly));
        Assert.assertEquals((String)acl.getOwner().getId(), (String)ownerId);
        Assert.assertEquals((String)acl.getOwner().getDisplayName(), (String)"jamesmurty");
        Assert.assertEquals((int)acl.getPermissions(ownerId).size(), (int)1);
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
        Assert.assertEquals((int)acl.getGrants().size(), (int)1);
        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.ALL_USERS).size(), (int)0);
        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.AUTHENTICATED_USERS).size(), (int)0);
        Assert.assertEquals((int)acl.getPermissions(AccessControlList.GroupGranteeURI.LOG_DELIVERY).size(), (int)0);
    }

    @Test
    public void testAccessControlListExtreme() throws HttpException {
        String ownerId = "1a405254c932b52e5b5caaa88186bc431a1bacb9ece631f835daddaf0c47677c";
        AccessControlList acl = (AccessControlList)this.createParser().parse(Strings2.toInputStream((String)aclExtreme));
        Assert.assertEquals((String)acl.getOwner().getId(), (String)ownerId);
        Assert.assertEquals((String)acl.getOwner().getDisplayName(), (String)"jamesmurty");
        Assert.assertEquals((int)acl.getPermissions(ownerId).size(), (int)3);
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "FULL_CONTROL"));
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "READ"));
        Assert.assertTrue((boolean)acl.hasPermission(ownerId, "WRITE"));
        Assert.assertEquals((int)acl.getGrants().size(), (int)9);
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ"));
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.AUTHENTICATED_USERS, "READ"));
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.AUTHENTICATED_USERS, "WRITE"));
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.AUTHENTICATED_USERS, "READ_ACP"));
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.AUTHENTICATED_USERS, "WRITE_ACP"));
        Assert.assertTrue((boolean)acl.hasPermission(AccessControlList.GroupGranteeURI.LOG_DELIVERY, "WRITE"));
    }
}

