/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.io.InputStream;
import java.net.URI;
import java.util.TreeSet;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.domain.internal.ListBucketResponseImpl;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ListBucketHandlerTest")
public class ListBucketHandlerTest
extends BaseHandlerTest {
    public static final String listBucketWithPrefixAppsSlash = "<ListBucketResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Name>adriancole.org.jclouds.s3.amazons3testdelimiter</Name><Prefix>apps/</Prefix><Marker></Marker><MaxKeys>1000</MaxKeys><IsTruncated>false</IsTruncated><Contents><Key>apps/0</Key><LastModified>2009-05-07T18:27:08.000Z</LastModified><ETag>&quot;c82e6a0025c31c5de5947fda62ac51ab&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/1</Key><LastModified>2009-05-07T18:27:09.000Z</LastModified><ETag>&quot;944fab2c5a9a6bacf07db5e688310d7a&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/2</Key><LastModified>2009-05-07T18:27:09.000Z</LastModified><ETag>&quot;a227b8888045c8fd159fb495214000f0&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/3</Key><LastModified>2009-05-07T18:27:09.000Z</LastModified><ETag>&quot;c9caa76c3dec53e2a192608ce73eef03&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/4</Key><LastModified>2009-05-07T18:27:09.000Z</LastModified><ETag>&quot;1ce5d0dcc6154a647ea90c7bdf82a224&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/5</Key><LastModified>2009-05-07T18:27:09.000Z</LastModified><ETag>&quot;79433524d87462ee05708a8ef894ed55&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/6</Key><LastModified>2009-05-07T18:27:10.000Z</LastModified><ETag>&quot;dd00a060b28ddca8bc5a21a49e306f67&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/7</Key><LastModified>2009-05-07T18:27:10.000Z</LastModified><ETag>&quot;8cd06eca6e819a927b07a285d750b100&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/8</Key><LastModified>2009-05-07T18:27:10.000Z</LastModified><ETag>&quot;174495094d0633b92cbe46603eee6bad&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents><Contents><Key>apps/9</Key><LastModified>2009-05-07T18:27:10.000Z</LastModified><ETag>&quot;cd8a19b26fea8a827276df0ad11c580d&quot;</ETag><Size>8</Size><Owner><ID>e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0</ID><DisplayName>ferncam</DisplayName></Owner><StorageClass>STANDARD</StorageClass></Contents></ListBucketResult>";
    public static final String listBucketWithSlashDelimiterAndCommonPrefixApps = "<ListBucketResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"> <Delimiter>/</Delimiter> <CommonPrefixes><Prefix>apps/</Prefix></CommonPrefixes></ListBucketResult>";
    private DateService dateService = new SimpleDateFormatDateService();

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/list_bucket.xml");
        ListBucketResponse result = (ListBucketResponse)this.createParser().parse(is);
        ListBucketResponse expected = this.expected();
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public ListBucketResponse expected() {
        CanonicalUser owner = new CanonicalUser("e1a5f66a480ca99a4fdfe8e318c3020446c9989d7004e7778029fbcc5d990fa0", "ferncam");
        String bucket = "adriancole.org.jclouds.aws.s3.amazons3testdelimiter";
        ListBucketResponseImpl expected = new ListBucketResponseImpl(bucket, (Iterable)ImmutableList.of((Object)new ObjectMetadataBuilder().key("apps/0").bucket(bucket).uri(URI.create("http://bucket.com/apps/0")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:08.000Z")).eTag("\"c82e6a0025c31c5de5947fda62ac51ab\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"c82e6a0025c31c5de5947fda62ac51ab")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/1").bucket(bucket).uri(URI.create("http://bucket.com/apps/1")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:09.000Z")).eTag("\"944fab2c5a9a6bacf07db5e688310d7a\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"944fab2c5a9a6bacf07db5e688310d7a")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/2").bucket(bucket).uri(URI.create("http://bucket.com/apps/2")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:09.000Z")).eTag("\"a227b8888045c8fd159fb495214000f0\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"a227b8888045c8fd159fb495214000f0")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/3").bucket(bucket).uri(URI.create("http://bucket.com/apps/3")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:09.000Z")).eTag("\"c9caa76c3dec53e2a192608ce73eef03\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"c9caa76c3dec53e2a192608ce73eef03")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/4").bucket(bucket).uri(URI.create("http://bucket.com/apps/4")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:09.000Z")).eTag("\"1ce5d0dcc6154a647ea90c7bdf82a224\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"1ce5d0dcc6154a647ea90c7bdf82a224")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/5").bucket(bucket).uri(URI.create("http://bucket.com/apps/5")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:09.000Z")).eTag("\"79433524d87462ee05708a8ef894ed55\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"79433524d87462ee05708a8ef894ed55")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/6").bucket(bucket).uri(URI.create("http://bucket.com/apps/6")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:10.000Z")).eTag("\"dd00a060b28ddca8bc5a21a49e306f67\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"dd00a060b28ddca8bc5a21a49e306f67")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/7").bucket(bucket).uri(URI.create("http://bucket.com/apps/7")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:10.000Z")).eTag("\"8cd06eca6e819a927b07a285d750b100\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"8cd06eca6e819a927b07a285d750b100")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/8").bucket(bucket).uri(URI.create("http://bucket.com/apps/8")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:10.000Z")).eTag("\"174495094d0633b92cbe46603eee6bad\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"174495094d0633b92cbe46603eee6bad")).contentLength(Long.valueOf(8L)).build(), (Object)new ObjectMetadataBuilder().key("apps/9").bucket(bucket).uri(URI.create("http://bucket.com/apps/9")).lastModified(this.dateService.iso8601DateParse("2009-05-07T18:27:10.000Z")).eTag("\"cd8a19b26fea8a827276df0ad11c580d\"").owner(owner).contentMD5(BaseEncoding.base16().lowerCase().decode((CharSequence)"cd8a19b26fea8a827276df0ad11c580d")).contentLength(Long.valueOf(8L)).build()), "apps/", null, null, 1000, null, false, new TreeSet());
        return expected;
    }

    ParseSax<ListBucketResponse> createParser() {
        return this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ListBucketHandler.class)).setContext(HttpRequest.builder().method("GET").endpoint("http://bucket.com").build());
    }

    @Test
    public void testListMyBucketsWithDelimiterSlashAndCommonPrefixesAppsSlash() throws HttpException {
        ListBucketResponse bucket = (ListBucketResponse)this.createParser().parse(Strings2.toInputStream((String)listBucketWithSlashDelimiterAndCommonPrefixApps));
        Assert.assertEquals((String)((String)bucket.getCommonPrefixes().iterator().next()), (String)"apps/");
        Assert.assertEquals((String)bucket.getDelimiter(), (String)"/");
        assert (bucket.getMarker() == null);
    }

    @Test
    public void testListMyBucketsWithPrefixAppsSlash() throws HttpException {
        ListBucketResponse bucket = (ListBucketResponse)this.createParser().parse(Strings2.toInputStream((String)listBucketWithPrefixAppsSlash));
        Assert.assertEquals((String)bucket.getPrefix(), (String)"apps/");
        Assert.assertEquals((int)bucket.getMaxKeys(), (int)1000);
        assert (bucket.getMarker() == null);
    }
}

