/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.ObjectMetadata;

@Singleton
public class ObjectToBlobMetadata
implements Function<ObjectMetadata, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    private final LoadingCache<String, AccessControlList> bucketAcls;
    private final Function<String, Location> locationOfBucket;

    @Inject
    public ObjectToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName, LoadingCache<String, AccessControlList> bucketAcls, Function<String, Location> locationOfBucket) {
        this.ifDirectoryReturnName = ifDirectoryReturnName;
        this.bucketAcls = bucketAcls;
        this.locationOfBucket = locationOfBucket;
    }

    public MutableBlobMetadata apply(ObjectMetadata from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        try {
            AccessControlList bucketAcl = (AccessControlList)this.bucketAcls.getUnchecked((Object)from.getBucket());
            if (bucketAcl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
                to.setPublicUri(from.getUri());
            }
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        to.setUri(from.getUri());
        to.setContainer(from.getBucket());
        to.setETag(from.getETag());
        to.setName(from.getKey());
        to.setLastModified(from.getLastModified());
        to.setUserMetadata(from.getUserMetadata());
        to.setLocation((Location)this.locationOfBucket.apply((Object)from.getBucket()));
        String directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to);
        if (directoryName != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }
}

