/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.logging.Logger;
import org.jclouds.s3.Bucket;

@Singleton
public class AssignCorrectHostnameForBucket
implements Function<Object, URI> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final RegionToEndpointOrProviderIfNull r2;
    protected final Function<String, Optional<String>> bucketToRegion;

    @Inject
    public AssignCorrectHostnameForBucket(RegionToEndpointOrProviderIfNull r2, @Bucket Function<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
        this.r2 = r2;
    }

    public URI apply(@Nullable Object from) {
        String bucket = from.toString();
        Optional region = (Optional)this.bucketToRegion.apply((Object)bucket);
        if (region.isPresent()) {
            return this.r2.apply(region.get());
        }
        return this.r2.apply(null);
    }
}

