/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute;

import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.internal.ContextImpl;
import org.jclouds.servermanager.ServerManagerApiMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerManagerContextBuilderTest")
public class ServerManagerComputeServiceContextBuilderTest {
    @Test
    public void testCanBuildWithApiMetadata() {
        ComputeServiceContext context = (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)new ServerManagerApiMetadata()).build(ComputeServiceContext.class);
        context.close();
    }

    @Test
    public void testCanBuildById() {
        ComputeServiceContext context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"servermanager").build(ComputeServiceContext.class);
        context.close();
    }

    @Test
    public void testCanBuildWithOverridingProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("servermanager.endpoint", "http://host");
        overrides.setProperty("servermanager.api-version", "1");
        ComputeServiceContext context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"servermanager").overrides(overrides).build(ComputeServiceContext.class);
        context.close();
    }

    @Test
    public void testUnwrapIsCorrectType() {
        ComputeServiceContext context = (ComputeServiceContext)ContextBuilder.newBuilder((String)"servermanager").build(ComputeServiceContext.class);
        Assert.assertEquals(context.unwrap().getClass(), ContextImpl.class);
        context.close();
    }
}

