/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.servermanager.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.predicates.HardwarePredicates;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.servermanager.Server;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    public static final Map<Server.Status, NodeMetadata.Status> serverStatusToNodeStatus = ImmutableMap.builder().put((Object)Server.Status.ACTIVE, (Object)NodeMetadata.Status.RUNNING).put((Object)Server.Status.BUILD, (Object)NodeMetadata.Status.PENDING).put((Object)Server.Status.TERMINATED, (Object)NodeMetadata.Status.TERMINATED).put((Object)Server.Status.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Hardware>> hardware;
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Set<? extends Image>> images;
    private final Map<String, Credentials> credentialStore;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerToNodeMetadata(Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Hardware>> hardware, @Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.hardware = (Supplier)Preconditions.checkNotNull(hardware, (Object)"hardware");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
    }

    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.id + "");
        builder.name(from.name);
        builder.location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.datacenter)).orNull());
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.name));
        builder.imageId(from.imageId + "");
        Image image = (Image)FluentIterable.from((Iterable)((Iterable)this.images.get())).firstMatch(ImagePredicates.idEquals((String)(from.imageId + ""))).orNull();
        if (image != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.hardware((Hardware)FluentIterable.from((Iterable)((Iterable)this.hardware.get())).firstMatch(HardwarePredicates.idEquals((String)(from.hardwareId + ""))).orNull());
        builder.status(serverStatusToNodeStatus.get((Object)from.status));
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.publicAddress));
        builder.privateAddresses((Iterable)ImmutableSet.of((Object)from.privateAddress));
        builder.credentials(LoginCredentials.fromCredentials((Credentials)this.credentialStore.get(from.id + "")));
        return builder.build();
    }
}

