/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.aws.config.FormSigningRestClientModule;
import org.jclouds.aws.handlers.AWSServerErrorRetryHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.SQSAsyncApi;
import org.jclouds.sqs.features.MessageApi;
import org.jclouds.sqs.features.MessageAsyncApi;
import org.jclouds.sqs.features.PermissionApi;
import org.jclouds.sqs.features.PermissionAsyncApi;
import org.jclouds.sqs.features.QueueApi;
import org.jclouds.sqs.features.QueueAsyncApi;
import org.jclouds.sqs.handlers.ParseSQSErrorFromXmlContent;
import org.jclouds.sqs.handlers.SQSErrorRetryHandler;

@ConfiguresRestClient
public class SQSRestClientModule
extends FormSigningRestClientModule<SQSApi, SQSAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(QueueApi.class, QueueAsyncApi.class).put(MessageApi.class, MessageAsyncApi.class).put(PermissionApi.class, PermissionAsyncApi.class).build();

    public SQSRestClientModule() {
        super(Reflection2.typeToken(SQSApi.class), Reflection2.typeToken(SQSAsyncApi.class), DELEGATE_MAP);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseSQSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseSQSErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseSQSErrorFromXmlContent.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(SQSErrorRetryHandler.class);
        this.bind(HttpRetryHandler.class).annotatedWith(ServerError.class).to(AWSServerErrorRetryHandler.class);
    }
}

