/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.jclouds.ContextBuilder;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.aws.xml.SessionCredentialsHandlerTest;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.IntegrationTestAsyncClient;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="FormSignerTest")
public class FormSignerTest {
    public static FormSigner staticCredentialsFilter = FormSignerTest.filter(new Credentials("identity", "credential"));
    HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost").addHeader("Host", new String[]{"localhost"})).addFormParam("Action", new String[]{"DescribeImages"}).addFormParam("ImageId.1", new String[]{"ami-2bb65342"}).build();

    public static Injector injector(Credentials creds) {
        return ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(IntegrationTestClient.class, IntegrationTestAsyncClient.class, (String)"http://localhost")).credentialsSupplier(Suppliers.ofInstance((Object)creds)).apiVersion("apiVersion").modules((Iterable)ImmutableList.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule(), (Object)new AbstractModule(){

            protected void configure() {
                this.bind(RequestSigner.class).to(FormSigner.class);
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"jclouds.aws.header.tag")).toInstance((Object)"amz");
                this.bind(String.class).annotatedWith(TimeStamp.class).toInstance((Object)"2009-11-08T15:54:08.897Z");
            }
        })).buildInjector();
    }

    public static FormSigner filter(Credentials creds) {
        return (FormSigner)FormSignerTest.injector(creds).getInstance(FormSigner.class);
    }

    @Test
    void testAddsSecurityToken() {
        HttpRequest filtered = FormSignerTest.filter((Credentials)new SessionCredentialsHandlerTest().expected()).filter(this.request);
        Assert.assertEquals((Object)filtered.getPayload().getRawContent(), (Object)"Action=DescribeImages&ImageId.1=ami-2bb65342&SecurityToken=AQoEXAMPLEH4aoAH0gNCAPyJxz4BlCFFxWNE1OPTgk5TthT&Signature=/8ReFVH1tvyNORsJb%2BSBieT9zvdqREQQr/olwmxC7VY%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2009-11-08T15%3A54%3A08.897Z&Version=apiVersion&AWSAccessKeyId=AKIAIOSFODNN7EXAMPLE");
    }

    @Test
    void testBuildCanonicalizedStringSetsVersion() {
        HttpRequest filtered = staticCredentialsFilter.filter(this.request);
        Assert.assertEquals((Object)filtered.getPayload().getRawContent(), (Object)"Action=DescribeImages&ImageId.1=ami-2bb65342&Signature=ugnt4m2eHE7Ka/vXTr9EhKZq7bhxOfvW0y4pAEqF97w%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Timestamp=2009-11-08T15%3A54%3A08.897Z&Version=apiVersion&AWSAccessKeyId=identity");
    }

    @Test
    void testBuildCanonicalizedString() {
        Assert.assertEquals((String)staticCredentialsFilter.buildCanonicalizedString((Multimap)new ImmutableMultimap.Builder().put((Object)"AWSAccessKeyId", (Object)"foo").put((Object)"Action", (Object)"DescribeImages").put((Object)"Expires", (Object)"2008-02-10T12:00:00Z").put((Object)"ImageId.1", (Object)"ami-2bb65342").put((Object)"SignatureMethod", (Object)"HmacSHA256").put((Object)"SignatureVersion", (Object)"2").put((Object)"Version", (Object)"2010-06-15").build()), (String)"AWSAccessKeyId=foo&Action=DescribeImages&Expires=2008-02-10T12%3A00%3A00Z&ImageId.1=ami-2bb65342&SignatureMethod=HmacSHA256&SignatureVersion=2&Version=2010-06-15");
    }
}

